<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConventionalContractOptions StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ConventionalContractOptions
 * @subpackage Structs
 */
class ConventionalContractOptions extends AbstractStructBase
{
    /**
     * The EscalationRate
     * @var string
     */
    public $EscalationRate;
    /**
     * Constructor method for ConventionalContractOptions
     * @uses ConventionalContractOptions::setEscalationRate()
     * @param string $escalationRate
     */
    public function __construct($escalationRate = null)
    {
        $this
            ->setEscalationRate($escalationRate);
    }
    /**
     * Get EscalationRate value
     * @return string|null
     */
    public function getEscalationRate()
    {
        return $this->EscalationRate;
    }
    /**
     * Set EscalationRate value
     * @uses \EnumType\EscalationRate::valueIsValid()
     * @uses \EnumType\EscalationRate::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $escalationRate
     * @return \StructType\ConventionalContractOptions
     */
    public function setEscalationRate($escalationRate = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EscalationRate::valueIsValid($escalationRate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\EscalationRate', is_array($escalationRate) ? implode(', ', $escalationRate) : var_export($escalationRate, true), implode(', ', \EnumType\EscalationRate::getValidValues())), __LINE__);
        }
        $this->EscalationRate = $escalationRate;
        return $this;
    }
}
