<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ComparisonQuoteReportRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ComparisonQuoteReportRequest
 * @subpackage Structs
 */
class ComparisonQuoteReportRequest extends AbstractStructBase
{
    /**
     * The ComparisonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ComparisonId;
    /**
     * The RemoveBranding
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $RemoveBranding;
    /**
     * The ReportFormat
     * @var string
     */
    public $ReportFormat;
    /**
     * Constructor method for ComparisonQuoteReportRequest
     * @uses ComparisonQuoteReportRequest::setComparisonId()
     * @uses ComparisonQuoteReportRequest::setRemoveBranding()
     * @uses ComparisonQuoteReportRequest::setReportFormat()
     * @param string $comparisonId
     * @param bool $removeBranding
     * @param string $reportFormat
     */
    public function __construct($comparisonId = null, $removeBranding = null, $reportFormat = null)
    {
        $this
            ->setComparisonId($comparisonId)
            ->setRemoveBranding($removeBranding)
            ->setReportFormat($reportFormat);
    }
    /**
     * Get ComparisonId value
     * @return string|null
     */
    public function getComparisonId()
    {
        return $this->ComparisonId;
    }
    /**
     * Set ComparisonId value
     * @param string $comparisonId
     * @return \StructType\ComparisonQuoteReportRequest
     */
    public function setComparisonId($comparisonId = null)
    {
        // validation for constraint: string
        if (!is_null($comparisonId) && !is_string($comparisonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comparisonId, true), gettype($comparisonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($comparisonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $comparisonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($comparisonId, true)), __LINE__);
        }
        $this->ComparisonId = $comparisonId;
        return $this;
    }
    /**
     * Get RemoveBranding value
     * @return bool|null
     */
    public function getRemoveBranding()
    {
        return $this->RemoveBranding;
    }
    /**
     * Set RemoveBranding value
     * @param bool $removeBranding
     * @return \StructType\ComparisonQuoteReportRequest
     */
    public function setRemoveBranding($removeBranding = null)
    {
        // validation for constraint: boolean
        if (!is_null($removeBranding) && !is_bool($removeBranding)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($removeBranding, true), gettype($removeBranding)), __LINE__);
        }
        $this->RemoveBranding = $removeBranding;
        return $this;
    }
    /**
     * Get ReportFormat value
     * @return string|null
     */
    public function getReportFormat()
    {
        return $this->ReportFormat;
    }
    /**
     * Set ReportFormat value
     * @uses \EnumType\ReportDataFormat::valueIsValid()
     * @uses \EnumType\ReportDataFormat::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reportFormat
     * @return \StructType\ComparisonQuoteReportRequest
     */
    public function setReportFormat($reportFormat = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ReportDataFormat::valueIsValid($reportFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ReportDataFormat', is_array($reportFormat) ? implode(', ', $reportFormat) : var_export($reportFormat, true), implode(', ', \EnumType\ReportDataFormat::getValidValues())), __LINE__);
        }
        $this->ReportFormat = $reportFormat;
        return $this;
    }
}
