<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AnnuityComparisonQuoteResult StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AnnuityComparisonQuoteResult
 * @subpackage Structs
 */
class AnnuityComparisonQuoteResult extends AbstractStructBase
{
    /**
     * The AnnuityQuoteResults
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfAnnuityQuoteResult
     */
    public $AnnuityQuoteResults;
    /**
     * The QuotesCompleted
     * @var int
     */
    public $QuotesCompleted;
    /**
     * The QuotesGenerated
     * @var int
     */
    public $QuotesGenerated;
    /**
     * The Status
     * @var string
     */
    public $Status;
    /**
     * The TransactionHeaders
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\TransactionHeaders
     */
    public $TransactionHeaders;
    /**
     * The UnavailableProducts
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfUnavailableProduct
     */
    public $UnavailableProducts;
    /**
     * Constructor method for AnnuityComparisonQuoteResult
     * @uses AnnuityComparisonQuoteResult::setAnnuityQuoteResults()
     * @uses AnnuityComparisonQuoteResult::setQuotesCompleted()
     * @uses AnnuityComparisonQuoteResult::setQuotesGenerated()
     * @uses AnnuityComparisonQuoteResult::setStatus()
     * @uses AnnuityComparisonQuoteResult::setTransactionHeaders()
     * @uses AnnuityComparisonQuoteResult::setUnavailableProducts()
     * @param \ArrayType\ArrayOfAnnuityQuoteResult $annuityQuoteResults
     * @param int $quotesCompleted
     * @param int $quotesGenerated
     * @param string $status
     * @param \StructType\TransactionHeaders $transactionHeaders
     * @param \ArrayType\ArrayOfUnavailableProduct $unavailableProducts
     */
    public function __construct(\ArrayType\ArrayOfAnnuityQuoteResult $annuityQuoteResults = null, $quotesCompleted = null, $quotesGenerated = null, $status = null, \StructType\TransactionHeaders $transactionHeaders = null, \ArrayType\ArrayOfUnavailableProduct $unavailableProducts = null)
    {
        $this
            ->setAnnuityQuoteResults($annuityQuoteResults)
            ->setQuotesCompleted($quotesCompleted)
            ->setQuotesGenerated($quotesGenerated)
            ->setStatus($status)
            ->setTransactionHeaders($transactionHeaders)
            ->setUnavailableProducts($unavailableProducts);
    }
    /**
     * Get AnnuityQuoteResults value
     * @return \ArrayType\ArrayOfAnnuityQuoteResult|null
     */
    public function getAnnuityQuoteResults()
    {
        return $this->AnnuityQuoteResults;
    }
    /**
     * Set AnnuityQuoteResults value
     * @param \ArrayType\ArrayOfAnnuityQuoteResult $annuityQuoteResults
     * @return \StructType\AnnuityComparisonQuoteResult
     */
    public function setAnnuityQuoteResults(\ArrayType\ArrayOfAnnuityQuoteResult $annuityQuoteResults = null)
    {
        $this->AnnuityQuoteResults = $annuityQuoteResults;
        return $this;
    }
    /**
     * Get QuotesCompleted value
     * @return int|null
     */
    public function getQuotesCompleted()
    {
        return $this->QuotesCompleted;
    }
    /**
     * Set QuotesCompleted value
     * @param int $quotesCompleted
     * @return \StructType\AnnuityComparisonQuoteResult
     */
    public function setQuotesCompleted($quotesCompleted = null)
    {
        // validation for constraint: int
        if (!is_null($quotesCompleted) && !(is_int($quotesCompleted) || ctype_digit($quotesCompleted))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quotesCompleted, true), gettype($quotesCompleted)), __LINE__);
        }
        $this->QuotesCompleted = $quotesCompleted;
        return $this;
    }
    /**
     * Get QuotesGenerated value
     * @return int|null
     */
    public function getQuotesGenerated()
    {
        return $this->QuotesGenerated;
    }
    /**
     * Set QuotesGenerated value
     * @param int $quotesGenerated
     * @return \StructType\AnnuityComparisonQuoteResult
     */
    public function setQuotesGenerated($quotesGenerated = null)
    {
        // validation for constraint: int
        if (!is_null($quotesGenerated) && !(is_int($quotesGenerated) || ctype_digit($quotesGenerated))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quotesGenerated, true), gettype($quotesGenerated)), __LINE__);
        }
        $this->QuotesGenerated = $quotesGenerated;
        return $this;
    }
    /**
     * Get Status value
     * @return string|null
     */
    public function getStatus()
    {
        return $this->Status;
    }
    /**
     * Set Status value
     * @uses \EnumType\ComparisonQuoteStatus::valueIsValid()
     * @uses \EnumType\ComparisonQuoteStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \StructType\AnnuityComparisonQuoteResult
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ComparisonQuoteStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ComparisonQuoteStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \EnumType\ComparisonQuoteStatus::getValidValues())), __LINE__);
        }
        $this->Status = $status;
        return $this;
    }
    /**
     * Get TransactionHeaders value
     * @return \StructType\TransactionHeaders|null
     */
    public function getTransactionHeaders()
    {
        return $this->TransactionHeaders;
    }
    /**
     * Set TransactionHeaders value
     * @param \StructType\TransactionHeaders $transactionHeaders
     * @return \StructType\AnnuityComparisonQuoteResult
     */
    public function setTransactionHeaders(\StructType\TransactionHeaders $transactionHeaders = null)
    {
        $this->TransactionHeaders = $transactionHeaders;
        return $this;
    }
    /**
     * Get UnavailableProducts value
     * @return \ArrayType\ArrayOfUnavailableProduct|null
     */
    public function getUnavailableProducts()
    {
        return $this->UnavailableProducts;
    }
    /**
     * Set UnavailableProducts value
     * @param \ArrayType\ArrayOfUnavailableProduct $unavailableProducts
     * @return \StructType\AnnuityComparisonQuoteResult
     */
    public function setUnavailableProducts(\ArrayType\ArrayOfUnavailableProduct $unavailableProducts = null)
    {
        $this->UnavailableProducts = $unavailableProducts;
        return $this;
    }
}
