<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReportDocument StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ReportDocument
 * @subpackage Structs
 */
class ReportDocument extends AbstractStructBase
{
    /**
     * The ComparisonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ComparisonId;
    /**
     * The Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Data;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The Format
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Format;
    /**
     * Constructor method for ReportDocument
     * @uses ReportDocument::setComparisonId()
     * @uses ReportDocument::setData()
     * @uses ReportDocument::setDescription()
     * @uses ReportDocument::setFormat()
     * @param string $comparisonId
     * @param string $data
     * @param string $description
     * @param string $format
     */
    public function __construct($comparisonId = null, $data = null, $description = null, $format = null)
    {
        $this
            ->setComparisonId($comparisonId)
            ->setData($data)
            ->setDescription($description)
            ->setFormat($format);
    }
    /**
     * Get ComparisonId value
     * @return string|null
     */
    public function getComparisonId()
    {
        return $this->ComparisonId;
    }
    /**
     * Set ComparisonId value
     * @param string $comparisonId
     * @return \StructType\ReportDocument
     */
    public function setComparisonId($comparisonId = null)
    {
        // validation for constraint: string
        if (!is_null($comparisonId) && !is_string($comparisonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comparisonId, true), gettype($comparisonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($comparisonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $comparisonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($comparisonId, true)), __LINE__);
        }
        $this->ComparisonId = $comparisonId;
        return $this;
    }
    /**
     * Get Data value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getData()
    {
        return isset($this->Data) ? $this->Data : null;
    }
    /**
     * Set Data value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $data
     * @return \StructType\ReportDocument
     */
    public function setData($data = null)
    {
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($data, true), gettype($data)), __LINE__);
        }
        if (is_null($data) || (is_array($data) && empty($data))) {
            unset($this->Data);
        } else {
            $this->Data = $data;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \StructType\ReportDocument
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Format value
     * @return string|null
     */
    public function getFormat()
    {
        return $this->Format;
    }
    /**
     * Set Format value
     * @uses \EnumType\ReportDataFormat::valueIsValid()
     * @uses \EnumType\ReportDataFormat::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $format
     * @return \StructType\ReportDocument
     */
    public function setFormat($format = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\ReportDataFormat::valueIsValid($format)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\ReportDataFormat', is_array($format) ? implode(', ', $format) : var_export($format, true), implode(', ', \EnumType\ReportDataFormat::getValidValues())), __LINE__);
        }
        $this->Format = $format;
        return $this;
    }
}
