<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProviderQuoteStatus StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ProviderQuoteStatus
 * @subpackage Structs
 */
class ProviderQuoteStatus extends AbstractStructBase
{
    /**
     * The Errors
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $Errors;
    /**
     * The Explanations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $Explanations;
    /**
     * The QuoteStatus
     * @var string
     */
    public $QuoteStatus;
    /**
     * The Warnings
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $Warnings;
    /**
     * Constructor method for ProviderQuoteStatus
     * @uses ProviderQuoteStatus::setErrors()
     * @uses ProviderQuoteStatus::setExplanations()
     * @uses ProviderQuoteStatus::setQuoteStatus()
     * @uses ProviderQuoteStatus::setWarnings()
     * @param \ArrayType\ArrayOfstring $errors
     * @param \ArrayType\ArrayOfstring $explanations
     * @param string $quoteStatus
     * @param \ArrayType\ArrayOfstring $warnings
     */
    public function __construct(\ArrayType\ArrayOfstring $errors = null, \ArrayType\ArrayOfstring $explanations = null, $quoteStatus = null, \ArrayType\ArrayOfstring $warnings = null)
    {
        $this
            ->setErrors($errors)
            ->setExplanations($explanations)
            ->setQuoteStatus($quoteStatus)
            ->setWarnings($warnings);
    }
    /**
     * Get Errors value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getErrors()
    {
        return isset($this->Errors) ? $this->Errors : null;
    }
    /**
     * Set Errors value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $errors
     * @return \StructType\ProviderQuoteStatus
     */
    public function setErrors(\ArrayType\ArrayOfstring $errors = null)
    {
        if (is_null($errors) || (is_array($errors) && empty($errors))) {
            unset($this->Errors);
        } else {
            $this->Errors = $errors;
        }
        return $this;
    }
    /**
     * Get Explanations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getExplanations()
    {
        return isset($this->Explanations) ? $this->Explanations : null;
    }
    /**
     * Set Explanations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $explanations
     * @return \StructType\ProviderQuoteStatus
     */
    public function setExplanations(\ArrayType\ArrayOfstring $explanations = null)
    {
        if (is_null($explanations) || (is_array($explanations) && empty($explanations))) {
            unset($this->Explanations);
        } else {
            $this->Explanations = $explanations;
        }
        return $this;
    }
    /**
     * Get QuoteStatus value
     * @return string|null
     */
    public function getQuoteStatus()
    {
        return $this->QuoteStatus;
    }
    /**
     * Set QuoteStatus value
     * @uses \EnumType\QuoteStatus::valueIsValid()
     * @uses \EnumType\QuoteStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $quoteStatus
     * @return \StructType\ProviderQuoteStatus
     */
    public function setQuoteStatus($quoteStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\QuoteStatus::valueIsValid($quoteStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\QuoteStatus', is_array($quoteStatus) ? implode(', ', $quoteStatus) : var_export($quoteStatus, true), implode(', ', \EnumType\QuoteStatus::getValidValues())), __LINE__);
        }
        $this->QuoteStatus = $quoteStatus;
        return $this;
    }
    /**
     * Get Warnings value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getWarnings()
    {
        return isset($this->Warnings) ? $this->Warnings : null;
    }
    /**
     * Set Warnings value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $warnings
     * @return \StructType\ProviderQuoteStatus
     */
    public function setWarnings(\ArrayType\ArrayOfstring $warnings = null)
    {
        if (is_null($warnings) || (is_array($warnings) && empty($warnings))) {
            unset($this->Warnings);
        } else {
            $this->Warnings = $warnings;
        }
        return $this;
    }
}
