<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MessageHeader StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MessageHeader
 * @subpackage Structs
 */
class MessageHeader extends AbstractStructBase
{
    /**
     * The ApplicationName
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $ApplicationName;
    /**
     * Constructor method for MessageHeader
     * @uses MessageHeader::setApplicationName()
     * @param string $applicationName
     */
    public function __construct($applicationName = null)
    {
        $this
            ->setApplicationName($applicationName);
    }
    /**
     * Get ApplicationName value
     * @return string|null
     */
    public function getApplicationName()
    {
        return $this->ApplicationName;
    }
    /**
     * Set ApplicationName value
     * @param string $applicationName
     * @return \StructType\MessageHeader
     */
    public function setApplicationName($applicationName = null)
    {
        // validation for constraint: string
        if (!is_null($applicationName) && !is_string($applicationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationName, true), gettype($applicationName)), __LINE__);
        }
        $this->ApplicationName = $applicationName;
        return $this;
    }
}
