<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BasisOfSale StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BasisOfSale
 * @subpackage Structs
 */
class BasisOfSale extends AbstractStructBase
{
    /**
     * The AdviceType
     * @var string
     */
    public $AdviceType;
    /**
     * The RdrBasisOfSale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RdrBasisOfSale;
    /**
     * Constructor method for BasisOfSale
     * @uses BasisOfSale::setAdviceType()
     * @uses BasisOfSale::setRdrBasisOfSale()
     * @param string $adviceType
     * @param string $rdrBasisOfSale
     */
    public function __construct($adviceType = null, $rdrBasisOfSale = null)
    {
        $this
            ->setAdviceType($adviceType)
            ->setRdrBasisOfSale($rdrBasisOfSale);
    }
    /**
     * Get AdviceType value
     * @return string|null
     */
    public function getAdviceType()
    {
        return $this->AdviceType;
    }
    /**
     * Set AdviceType value
     * @uses \EnumType\AdviceType::valueIsValid()
     * @uses \EnumType\AdviceType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $adviceType
     * @return \StructType\BasisOfSale
     */
    public function setAdviceType($adviceType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AdviceType::valueIsValid($adviceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AdviceType', is_array($adviceType) ? implode(', ', $adviceType) : var_export($adviceType, true), implode(', ', \EnumType\AdviceType::getValidValues())), __LINE__);
        }
        $this->AdviceType = $adviceType;
        return $this;
    }
    /**
     * Get RdrBasisOfSale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRdrBasisOfSale()
    {
        return isset($this->RdrBasisOfSale) ? $this->RdrBasisOfSale : null;
    }
    /**
     * Set RdrBasisOfSale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \EnumType\RdrBasisOfSale::valueIsValid()
     * @uses \EnumType\RdrBasisOfSale::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $rdrBasisOfSale
     * @return \StructType\BasisOfSale
     */
    public function setRdrBasisOfSale($rdrBasisOfSale = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RdrBasisOfSale::valueIsValid($rdrBasisOfSale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RdrBasisOfSale', is_array($rdrBasisOfSale) ? implode(', ', $rdrBasisOfSale) : var_export($rdrBasisOfSale, true), implode(', ', \EnumType\RdrBasisOfSale::getValidValues())), __LINE__);
        }
        if (is_null($rdrBasisOfSale) || (is_array($rdrBasisOfSale) && empty($rdrBasisOfSale))) {
            unset($this->RdrBasisOfSale);
        } else {
            $this->RdrBasisOfSale = $rdrBasisOfSale;
        }
        return $this;
    }
}
