<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GuaranteedAnnualIncomeDetail StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GuaranteedAnnualIncomeDetail
 * @subpackage Structs
 */
class GuaranteedAnnualIncomeDetail extends AbstractStructBase
{
    /**
     * The Amount
     * @var float
     */
    public $Amount;
    /**
     * The StartAge
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $StartAge;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * Constructor method for GuaranteedAnnualIncomeDetail
     * @uses GuaranteedAnnualIncomeDetail::setAmount()
     * @uses GuaranteedAnnualIncomeDetail::setStartAge()
     * @uses GuaranteedAnnualIncomeDetail::setStartDate()
     * @uses GuaranteedAnnualIncomeDetail::setType()
     * @param float $amount
     * @param int $startAge
     * @param string $startDate
     * @param string $type
     */
    public function __construct($amount = null, $startAge = null, $startDate = null, $type = null)
    {
        $this
            ->setAmount($amount)
            ->setStartAge($startAge)
            ->setStartDate($startDate)
            ->setType($type);
    }
    /**
     * Get Amount value
     * @return float|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param float $amount
     * @return \StructType\GuaranteedAnnualIncomeDetail
     */
    public function setAmount($amount = null)
    {
        // validation for constraint: float
        if (!is_null($amount) && !(is_float($amount) || is_numeric($amount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($amount, true), gettype($amount)), __LINE__);
        }
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Get StartAge value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getStartAge()
    {
        return isset($this->StartAge) ? $this->StartAge : null;
    }
    /**
     * Set StartAge value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $startAge
     * @return \StructType\GuaranteedAnnualIncomeDetail
     */
    public function setStartAge($startAge = null)
    {
        // validation for constraint: int
        if (!is_null($startAge) && !(is_int($startAge) || ctype_digit($startAge))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($startAge, true), gettype($startAge)), __LINE__);
        }
        if (is_null($startAge) || (is_array($startAge) && empty($startAge))) {
            unset($this->StartAge);
        } else {
            $this->StartAge = $startAge;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDate
     * @return \StructType\GuaranteedAnnualIncomeDetail
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \EnumType\GuaranteedAnnualIncomeType::valueIsValid()
     * @uses \EnumType\GuaranteedAnnualIncomeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \StructType\GuaranteedAnnualIncomeDetail
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\GuaranteedAnnualIncomeType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\GuaranteedAnnualIncomeType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \EnumType\GuaranteedAnnualIncomeType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
}
