<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Commission StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Commission
 * @subpackage Structs
 */
class Commission extends AbstractStructBase
{
    /**
     * The CommissionAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CommissionAmount;
    /**
     * The CommissionPercentage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CommissionPercentage;
    /**
     * The CommissionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CommissionType;
    /**
     * Constructor method for Commission
     * @uses Commission::setCommissionAmount()
     * @uses Commission::setCommissionPercentage()
     * @uses Commission::setCommissionType()
     * @param float $commissionAmount
     * @param float $commissionPercentage
     * @param string $commissionType
     */
    public function __construct($commissionAmount = null, $commissionPercentage = null, $commissionType = null)
    {
        $this
            ->setCommissionAmount($commissionAmount)
            ->setCommissionPercentage($commissionPercentage)
            ->setCommissionType($commissionType);
    }
    /**
     * Get CommissionAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCommissionAmount()
    {
        return isset($this->CommissionAmount) ? $this->CommissionAmount : null;
    }
    /**
     * Set CommissionAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $commissionAmount
     * @return \StructType\Commission
     */
    public function setCommissionAmount($commissionAmount = null)
    {
        // validation for constraint: float
        if (!is_null($commissionAmount) && !(is_float($commissionAmount) || is_numeric($commissionAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($commissionAmount, true), gettype($commissionAmount)), __LINE__);
        }
        if (is_null($commissionAmount) || (is_array($commissionAmount) && empty($commissionAmount))) {
            unset($this->CommissionAmount);
        } else {
            $this->CommissionAmount = $commissionAmount;
        }
        return $this;
    }
    /**
     * Get CommissionPercentage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCommissionPercentage()
    {
        return isset($this->CommissionPercentage) ? $this->CommissionPercentage : null;
    }
    /**
     * Set CommissionPercentage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $commissionPercentage
     * @return \StructType\Commission
     */
    public function setCommissionPercentage($commissionPercentage = null)
    {
        // validation for constraint: float
        if (!is_null($commissionPercentage) && !(is_float($commissionPercentage) || is_numeric($commissionPercentage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($commissionPercentage, true), gettype($commissionPercentage)), __LINE__);
        }
        if (is_null($commissionPercentage) || (is_array($commissionPercentage) && empty($commissionPercentage))) {
            unset($this->CommissionPercentage);
        } else {
            $this->CommissionPercentage = $commissionPercentage;
        }
        return $this;
    }
    /**
     * Get CommissionType value
     * @return string|null
     */
    public function getCommissionType()
    {
        return $this->CommissionType;
    }
    /**
     * Set CommissionType value
     * @uses \EnumType\CommissionType::valueIsValid()
     * @uses \EnumType\CommissionType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $commissionType
     * @return \StructType\Commission
     */
    public function setCommissionType($commissionType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CommissionType::valueIsValid($commissionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\CommissionType', is_array($commissionType) ? implode(', ', $commissionType) : var_export($commissionType, true), implode(', ', \EnumType\CommissionType::getValidValues())), __LINE__);
        }
        $this->CommissionType = $commissionType;
        return $this;
    }
}
