<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for QuoteStatus EnumType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:QuoteStatus
 * @subpackage Enumerations
 */
class QuoteStatus extends AbstractStructEnumBase
{
    /**
     * Constant for value 'Saved'
     * @return string 'Saved'
     */
    const VALUE_SAVED = 'Saved';
    /**
     * Constant for value 'Created'
     * @return string 'Created'
     */
    const VALUE_CREATED = 'Created';
    /**
     * Constant for value 'Submitted'
     * @return string 'Submitted'
     */
    const VALUE_SUBMITTED = 'Submitted';
    /**
     * Constant for value 'Completed'
     * @return string 'Completed'
     */
    const VALUE_COMPLETED = 'Completed';
    /**
     * Constant for value 'FailedToSend'
     * @return string 'FailedToSend'
     */
    const VALUE_FAILED_TO_SEND = 'FailedToSend';
    /**
     * Constant for value 'FailedToQuote'
     * @return string 'FailedToQuote'
     */
    const VALUE_FAILED_TO_QUOTE = 'FailedToQuote';
    /**
     * Constant for value 'CompletedWithErrors'
     * @return string 'CompletedWithErrors'
     */
    const VALUE_COMPLETED_WITH_ERRORS = 'CompletedWithErrors';
    /**
     * Constant for value 'CompletedWithWarnings'
     * @return string 'CompletedWithWarnings'
     */
    const VALUE_COMPLETED_WITH_WARNINGS = 'CompletedWithWarnings';
    /**
     * Return allowed values
     * @uses self::VALUE_SAVED
     * @uses self::VALUE_CREATED
     * @uses self::VALUE_SUBMITTED
     * @uses self::VALUE_COMPLETED
     * @uses self::VALUE_FAILED_TO_SEND
     * @uses self::VALUE_FAILED_TO_QUOTE
     * @uses self::VALUE_COMPLETED_WITH_ERRORS
     * @uses self::VALUE_COMPLETED_WITH_WARNINGS
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SAVED,
            self::VALUE_CREATED,
            self::VALUE_SUBMITTED,
            self::VALUE_COMPLETED,
            self::VALUE_FAILED_TO_SEND,
            self::VALUE_FAILED_TO_QUOTE,
            self::VALUE_COMPLETED_WITH_ERRORS,
            self::VALUE_COMPLETED_WITH_WARNINGS,
        );
    }
}
