<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ZConvertAmmount StructType
 * @subpackage Structs
 */
class ZConvertAmmount extends AbstractStructBase
{
    /**
     * The PDataConversione
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * @var string
     */
    public $PDataConversione;
    /**
     * The PImpSoc
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $PImpSoc;
    /**
     * The PValDest
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 5
     * @var string
     */
    public $PValDest;
    /**
     * The PValSoc
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 5
     * @var string
     */
    public $PValSoc;
    /**
     * Constructor method for ZConvertAmmount
     * @uses ZConvertAmmount::setPDataConversione()
     * @uses ZConvertAmmount::setPImpSoc()
     * @uses ZConvertAmmount::setPValDest()
     * @uses ZConvertAmmount::setPValSoc()
     * @param string $pDataConversione
     * @param string $pImpSoc
     * @param string $pValDest
     * @param string $pValSoc
     */
    public function __construct($pDataConversione = null, $pImpSoc = null, $pValDest = null, $pValSoc = null)
    {
        $this
            ->setPDataConversione($pDataConversione)
            ->setPImpSoc($pImpSoc)
            ->setPValDest($pValDest)
            ->setPValSoc($pValSoc);
    }
    /**
     * Get PDataConversione value
     * @return string|null
     */
    public function getPDataConversione()
    {
        return $this->PDataConversione;
    }
    /**
     * Set PDataConversione value
     * @param string $pDataConversione
     * @return \StructType\ZConvertAmmount
     */
    public function setPDataConversione($pDataConversione = null)
    {
        // validation for constraint: string
        if (!is_null($pDataConversione) && !is_string($pDataConversione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pDataConversione, true), gettype($pDataConversione)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($pDataConversione) && mb_strlen($pDataConversione) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($pDataConversione)), __LINE__);
        }
        $this->PDataConversione = $pDataConversione;
        return $this;
    }
    /**
     * Get PImpSoc value
     * @return string|null
     */
    public function getPImpSoc()
    {
        return $this->PImpSoc;
    }
    /**
     * Set PImpSoc value
     * @param string $pImpSoc
     * @return \StructType\ZConvertAmmount
     */
    public function setPImpSoc($pImpSoc = null)
    {
        // validation for constraint: string
        if (!is_null($pImpSoc) && !is_string($pImpSoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pImpSoc, true), gettype($pImpSoc)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($pImpSoc) && mb_strlen($pImpSoc) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($pImpSoc)), __LINE__);
        }
        $this->PImpSoc = $pImpSoc;
        return $this;
    }
    /**
     * Get PValDest value
     * @return string|null
     */
    public function getPValDest()
    {
        return $this->PValDest;
    }
    /**
     * Set PValDest value
     * @param string $pValDest
     * @return \StructType\ZConvertAmmount
     */
    public function setPValDest($pValDest = null)
    {
        // validation for constraint: string
        if (!is_null($pValDest) && !is_string($pValDest)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pValDest, true), gettype($pValDest)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($pValDest) && mb_strlen($pValDest) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($pValDest)), __LINE__);
        }
        $this->PValDest = $pValDest;
        return $this;
    }
    /**
     * Get PValSoc value
     * @return string|null
     */
    public function getPValSoc()
    {
        return $this->PValSoc;
    }
    /**
     * Set PValSoc value
     * @param string $pValSoc
     * @return \StructType\ZConvertAmmount
     */
    public function setPValSoc($pValSoc = null)
    {
        // validation for constraint: string
        if (!is_null($pValSoc) && !is_string($pValSoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pValSoc, true), gettype($pValSoc)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($pValSoc) && mb_strlen($pValSoc) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($pValSoc)), __LINE__);
        }
        $this->PValSoc = $pValSoc;
        return $this;
    }
}
