<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for ZC ServiceType
 * @subpackage Services
 */
class ZC extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ZConvertAmmount
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ZConvertAmmount $parameters
     * @return \StructType\ZConvertAmmountResponse|bool
     */
    public function ZConvertAmmount(\StructType\ZConvertAmmount $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ZConvertAmmount($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ZConvertAmmountResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
