<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ZConvertAmmountResponse StructType
 * @subpackage Structs
 */
class ZConvertAmmountResponse extends AbstractStructBase
{
    /**
     * The PoDataConversione
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 10
     * - pattern: \d\d\d\d-\d\d-\d\d
     * @var string
     */
    public $PoDataConversione;
    /**
     * The PoEsito
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 2
     * @var string
     */
    public $PoEsito;
    /**
     * The PoImpDest
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 2
     * - totalDigits: 15
     * @var float
     */
    public $PoImpDest;
    /**
     * The PoMsg
     * Meta information extracted from the WSDL
     * - base: xsd:string
     * - maxLength: 50
     * @var string
     */
    public $PoMsg;
    /**
     * The PoRate
     * Meta information extracted from the WSDL
     * - base: xsd:decimal
     * - fractionDigits: 5
     * - totalDigits: 9
     * @var float
     */
    public $PoRate;
    /**
     * Constructor method for ZConvertAmmountResponse
     * @uses ZConvertAmmountResponse::setPoDataConversione()
     * @uses ZConvertAmmountResponse::setPoEsito()
     * @uses ZConvertAmmountResponse::setPoImpDest()
     * @uses ZConvertAmmountResponse::setPoMsg()
     * @uses ZConvertAmmountResponse::setPoRate()
     * @param string $poDataConversione
     * @param string $poEsito
     * @param float $poImpDest
     * @param string $poMsg
     * @param float $poRate
     */
    public function __construct($poDataConversione = null, $poEsito = null, $poImpDest = null, $poMsg = null, $poRate = null)
    {
        $this
            ->setPoDataConversione($poDataConversione)
            ->setPoEsito($poEsito)
            ->setPoImpDest($poImpDest)
            ->setPoMsg($poMsg)
            ->setPoRate($poRate);
    }
    /**
     * Get PoDataConversione value
     * @return string|null
     */
    public function getPoDataConversione()
    {
        return $this->PoDataConversione;
    }
    /**
     * Set PoDataConversione value
     * @param string $poDataConversione
     * @return \StructType\ZConvertAmmountResponse
     */
    public function setPoDataConversione($poDataConversione = null)
    {
        // validation for constraint: string
        if (!is_null($poDataConversione) && !is_string($poDataConversione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($poDataConversione, true), gettype($poDataConversione)), __LINE__);
        }
        // validation for constraint: maxLength(10)
        if (!is_null($poDataConversione) && mb_strlen($poDataConversione) > 10) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 10', mb_strlen($poDataConversione)), __LINE__);
        }
        // validation for constraint: pattern(\d\d\d\d-\d\d-\d\d)
        if (!is_null($poDataConversione) && !preg_match('/\\d\\d\\d\\d-\\d\\d-\\d\\d/', $poDataConversione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \d\d\d\d-\d\d-\d\d', var_export($poDataConversione, true)), __LINE__);
        }
        $this->PoDataConversione = $poDataConversione;
        return $this;
    }
    /**
     * Get PoEsito value
     * @return string|null
     */
    public function getPoEsito()
    {
        return $this->PoEsito;
    }
    /**
     * Set PoEsito value
     * @param string $poEsito
     * @return \StructType\ZConvertAmmountResponse
     */
    public function setPoEsito($poEsito = null)
    {
        // validation for constraint: string
        if (!is_null($poEsito) && !is_string($poEsito)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($poEsito, true), gettype($poEsito)), __LINE__);
        }
        // validation for constraint: maxLength(2)
        if (!is_null($poEsito) && mb_strlen($poEsito) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 2', mb_strlen($poEsito)), __LINE__);
        }
        $this->PoEsito = $poEsito;
        return $this;
    }
    /**
     * Get PoImpDest value
     * @return float|null
     */
    public function getPoImpDest()
    {
        return $this->PoImpDest;
    }
    /**
     * Set PoImpDest value
     * @param float $poImpDest
     * @return \StructType\ZConvertAmmountResponse
     */
    public function setPoImpDest($poImpDest = null)
    {
        // validation for constraint: float
        if (!is_null($poImpDest) && !(is_float($poImpDest) || is_numeric($poImpDest))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($poImpDest, true), gettype($poImpDest)), __LINE__);
        }
        // validation for constraint: fractionDigits(2)
        if (!is_null($poImpDest) && mb_strlen(mb_substr($poImpDest, false !== mb_strpos($poImpDest, '.') ? mb_strpos($poImpDest, '.') + 1 : mb_strlen($poImpDest))) > 2) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 2 fraction digits, %d given', var_export($poImpDest, true), mb_strlen(mb_substr($poImpDest, mb_strpos($poImpDest, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(15)
        if (!is_null($poImpDest) && mb_strlen(preg_replace('/(\D)/', '', $poImpDest)) > 15) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 15 digits, "%d" given', var_export($poImpDest, true), mb_strlen(preg_replace('/(\D)/', '', $poImpDest))), __LINE__);
        }
        $this->PoImpDest = $poImpDest;
        return $this;
    }
    /**
     * Get PoMsg value
     * @return string|null
     */
    public function getPoMsg()
    {
        return $this->PoMsg;
    }
    /**
     * Set PoMsg value
     * @param string $poMsg
     * @return \StructType\ZConvertAmmountResponse
     */
    public function setPoMsg($poMsg = null)
    {
        // validation for constraint: string
        if (!is_null($poMsg) && !is_string($poMsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($poMsg, true), gettype($poMsg)), __LINE__);
        }
        // validation for constraint: maxLength(50)
        if (!is_null($poMsg) && mb_strlen($poMsg) > 50) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 50', mb_strlen($poMsg)), __LINE__);
        }
        $this->PoMsg = $poMsg;
        return $this;
    }
    /**
     * Get PoRate value
     * @return float|null
     */
    public function getPoRate()
    {
        return $this->PoRate;
    }
    /**
     * Set PoRate value
     * @param float $poRate
     * @return \StructType\ZConvertAmmountResponse
     */
    public function setPoRate($poRate = null)
    {
        // validation for constraint: float
        if (!is_null($poRate) && !(is_float($poRate) || is_numeric($poRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($poRate, true), gettype($poRate)), __LINE__);
        }
        // validation for constraint: fractionDigits(5)
        if (!is_null($poRate) && mb_strlen(mb_substr($poRate, false !== mb_strpos($poRate, '.') ? mb_strpos($poRate, '.') + 1 : mb_strlen($poRate))) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must at most contain 5 fraction digits, %d given', var_export($poRate, true), mb_strlen(mb_substr($poRate, mb_strpos($poRate, '.') + 1))), __LINE__);
        }
        // validation for constraint: totalDigits(9)
        if (!is_null($poRate) && mb_strlen(preg_replace('/(\D)/', '', $poRate)) > 9) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must use at most 9 digits, "%d" given', var_export($poRate, true), mb_strlen(preg_replace('/(\D)/', '', $poRate))), __LINE__);
        }
        $this->PoRate = $poRate;
        return $this;
    }
}
