<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Get ServiceType
 * @subpackage Services
 */
class Get extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GetEnabledDataSet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetEnabledDataSet $parameters
     * @return \StructType\GetEnabledDataSetResponse|bool
     */
    public function GetEnabledDataSet(\StructType\GetEnabledDataSet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetEnabledDataSet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetSchemaDataSet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetSchemaDataSet $parameters
     * @return \StructType\GetSchemaDataSetResponse|bool
     */
    public function GetSchemaDataSet(\StructType\GetSchemaDataSet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetSchemaDataSet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDataSet
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDataSet $parameters
     * @return \StructType\GetDataSetResponse|bool
     */
    public function GetDataSet(\StructType\GetDataSet $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDataSet($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GetDataSetChanges
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GetDataSetChanges $parameters
     * @return \StructType\GetDataSetChangesResponse|bool
     */
    public function GetDataSetChanges(\StructType\GetDataSetChanges $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->GetDataSetChanges($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GetDataSetChangesResponse|\StructType\GetDataSetResponse|\StructType\GetEnabledDataSetResponse|\StructType\GetSchemaDataSetResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
