<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UnloadOrdersRequestEnvelope StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:UnloadOrdersRequestEnvelope
 * @subpackage Structs
 */
class UnloadOrdersRequestEnvelope extends AbstractStructBase
{
    /**
     * The branchIDField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $branchIDField;
    /**
     * The externalIDListField
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $externalIDListField;
    /**
     * The orderIdListField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $orderIdListField;
    /**
     * Constructor method for UnloadOrdersRequestEnvelope
     * @uses UnloadOrdersRequestEnvelope::setBranchIDField()
     * @uses UnloadOrdersRequestEnvelope::setExternalIDListField()
     * @uses UnloadOrdersRequestEnvelope::setOrderIdListField()
     * @param string $branchIDField
     * @param \ArrayType\ArrayOfstring $externalIDListField
     * @param \ArrayType\ArrayOfstring $orderIdListField
     */
    public function __construct($branchIDField = null, \ArrayType\ArrayOfstring $externalIDListField = null, \ArrayType\ArrayOfstring $orderIdListField = null)
    {
        $this
            ->setBranchIDField($branchIDField)
            ->setExternalIDListField($externalIDListField)
            ->setOrderIdListField($orderIdListField);
    }
    /**
     * Get branchIDField value
     * @return string|null
     */
    public function getBranchIDField()
    {
        return $this->branchIDField;
    }
    /**
     * Set branchIDField value
     * @param string $branchIDField
     * @return \StructType\UnloadOrdersRequestEnvelope
     */
    public function setBranchIDField($branchIDField = null)
    {
        // validation for constraint: string
        if (!is_null($branchIDField) && !is_string($branchIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchIDField, true), gettype($branchIDField)), __LINE__);
        }
        $this->branchIDField = $branchIDField;
        return $this;
    }
    /**
     * Get externalIDListField value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getExternalIDListField()
    {
        return isset($this->externalIDListField) ? $this->externalIDListField : null;
    }
    /**
     * Set externalIDListField value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfstring $externalIDListField
     * @return \StructType\UnloadOrdersRequestEnvelope
     */
    public function setExternalIDListField(\ArrayType\ArrayOfstring $externalIDListField = null)
    {
        if (is_null($externalIDListField) || (is_array($externalIDListField) && empty($externalIDListField))) {
            unset($this->externalIDListField);
        } else {
            $this->externalIDListField = $externalIDListField;
        }
        return $this;
    }
    /**
     * Get orderIdListField value
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getOrderIdListField()
    {
        return $this->orderIdListField;
    }
    /**
     * Set orderIdListField value
     * @param \ArrayType\ArrayOfstring $orderIdListField
     * @return \StructType\UnloadOrdersRequestEnvelope
     */
    public function setOrderIdListField(\ArrayType\ArrayOfstring $orderIdListField = null)
    {
        $this->orderIdListField = $orderIdListField;
        return $this;
    }
}
