<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ShipToDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ShipToDetails
 * @subpackage Structs
 */
class ShipToDetails extends AbstractStructBase
{
    /**
     * The accountKeyIdField
     * @var int
     */
    public $accountKeyIdField;
    /**
     * The addressField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $addressField;
    /**
     * The cityField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $cityField;
    /**
     * The latitudeField
     * @var float
     */
    public $latitudeField;
    /**
     * The longitudeField
     * @var float
     */
    public $longitudeField;
    /**
     * The stateField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $stateField;
    /**
     * The zipField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $zipField;
    /**
     * Constructor method for ShipToDetails
     * @uses ShipToDetails::setAccountKeyIdField()
     * @uses ShipToDetails::setAddressField()
     * @uses ShipToDetails::setCityField()
     * @uses ShipToDetails::setLatitudeField()
     * @uses ShipToDetails::setLongitudeField()
     * @uses ShipToDetails::setStateField()
     * @uses ShipToDetails::setZipField()
     * @param int $accountKeyIdField
     * @param string $addressField
     * @param string $cityField
     * @param float $latitudeField
     * @param float $longitudeField
     * @param string $stateField
     * @param string $zipField
     */
    public function __construct($accountKeyIdField = null, $addressField = null, $cityField = null, $latitudeField = null, $longitudeField = null, $stateField = null, $zipField = null)
    {
        $this
            ->setAccountKeyIdField($accountKeyIdField)
            ->setAddressField($addressField)
            ->setCityField($cityField)
            ->setLatitudeField($latitudeField)
            ->setLongitudeField($longitudeField)
            ->setStateField($stateField)
            ->setZipField($zipField);
    }
    /**
     * Get accountKeyIdField value
     * @return int|null
     */
    public function getAccountKeyIdField()
    {
        return $this->accountKeyIdField;
    }
    /**
     * Set accountKeyIdField value
     * @param int $accountKeyIdField
     * @return \StructType\ShipToDetails
     */
    public function setAccountKeyIdField($accountKeyIdField = null)
    {
        // validation for constraint: int
        if (!is_null($accountKeyIdField) && !(is_int($accountKeyIdField) || ctype_digit($accountKeyIdField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountKeyIdField, true), gettype($accountKeyIdField)), __LINE__);
        }
        $this->accountKeyIdField = $accountKeyIdField;
        return $this;
    }
    /**
     * Get addressField value
     * @return string|null
     */
    public function getAddressField()
    {
        return $this->addressField;
    }
    /**
     * Set addressField value
     * @param string $addressField
     * @return \StructType\ShipToDetails
     */
    public function setAddressField($addressField = null)
    {
        // validation for constraint: string
        if (!is_null($addressField) && !is_string($addressField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($addressField, true), gettype($addressField)), __LINE__);
        }
        $this->addressField = $addressField;
        return $this;
    }
    /**
     * Get cityField value
     * @return string|null
     */
    public function getCityField()
    {
        return $this->cityField;
    }
    /**
     * Set cityField value
     * @param string $cityField
     * @return \StructType\ShipToDetails
     */
    public function setCityField($cityField = null)
    {
        // validation for constraint: string
        if (!is_null($cityField) && !is_string($cityField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityField, true), gettype($cityField)), __LINE__);
        }
        $this->cityField = $cityField;
        return $this;
    }
    /**
     * Get latitudeField value
     * @return float|null
     */
    public function getLatitudeField()
    {
        return $this->latitudeField;
    }
    /**
     * Set latitudeField value
     * @param float $latitudeField
     * @return \StructType\ShipToDetails
     */
    public function setLatitudeField($latitudeField = null)
    {
        // validation for constraint: float
        if (!is_null($latitudeField) && !(is_float($latitudeField) || is_numeric($latitudeField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($latitudeField, true), gettype($latitudeField)), __LINE__);
        }
        $this->latitudeField = $latitudeField;
        return $this;
    }
    /**
     * Get longitudeField value
     * @return float|null
     */
    public function getLongitudeField()
    {
        return $this->longitudeField;
    }
    /**
     * Set longitudeField value
     * @param float $longitudeField
     * @return \StructType\ShipToDetails
     */
    public function setLongitudeField($longitudeField = null)
    {
        // validation for constraint: float
        if (!is_null($longitudeField) && !(is_float($longitudeField) || is_numeric($longitudeField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($longitudeField, true), gettype($longitudeField)), __LINE__);
        }
        $this->longitudeField = $longitudeField;
        return $this;
    }
    /**
     * Get stateField value
     * @return string|null
     */
    public function getStateField()
    {
        return $this->stateField;
    }
    /**
     * Set stateField value
     * @param string $stateField
     * @return \StructType\ShipToDetails
     */
    public function setStateField($stateField = null)
    {
        // validation for constraint: string
        if (!is_null($stateField) && !is_string($stateField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateField, true), gettype($stateField)), __LINE__);
        }
        $this->stateField = $stateField;
        return $this;
    }
    /**
     * Get zipField value
     * @return string|null
     */
    public function getZipField()
    {
        return $this->zipField;
    }
    /**
     * Set zipField value
     * @param string $zipField
     * @return \StructType\ShipToDetails
     */
    public function setZipField($zipField = null)
    {
        // validation for constraint: string
        if (!is_null($zipField) && !is_string($zipField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipField, true), gettype($zipField)), __LINE__);
        }
        $this->zipField = $zipField;
        return $this;
    }
}
