<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RouteSummaryReturnOptionsFilters StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RouteSummaryReturnOptionsFilters
 * @subpackage Structs
 */
class RouteSummaryReturnOptionsFilters extends AbstractStructBase
{
    /**
     * The dispatchIDListField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $dispatchIDListField;
    /**
     * The routeIDListField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfint
     */
    public $routeIDListField;
    /**
     * The routeTypeField
     * @var string
     */
    public $routeTypeField;
    /**
     * Constructor method for RouteSummaryReturnOptionsFilters
     * @uses RouteSummaryReturnOptionsFilters::setDispatchIDListField()
     * @uses RouteSummaryReturnOptionsFilters::setRouteIDListField()
     * @uses RouteSummaryReturnOptionsFilters::setRouteTypeField()
     * @param \ArrayType\ArrayOfstring $dispatchIDListField
     * @param \ArrayType\ArrayOfint $routeIDListField
     * @param string $routeTypeField
     */
    public function __construct(\ArrayType\ArrayOfstring $dispatchIDListField = null, \ArrayType\ArrayOfint $routeIDListField = null, $routeTypeField = null)
    {
        $this
            ->setDispatchIDListField($dispatchIDListField)
            ->setRouteIDListField($routeIDListField)
            ->setRouteTypeField($routeTypeField);
    }
    /**
     * Get dispatchIDListField value
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getDispatchIDListField()
    {
        return $this->dispatchIDListField;
    }
    /**
     * Set dispatchIDListField value
     * @param \ArrayType\ArrayOfstring $dispatchIDListField
     * @return \StructType\RouteSummaryReturnOptionsFilters
     */
    public function setDispatchIDListField(\ArrayType\ArrayOfstring $dispatchIDListField = null)
    {
        $this->dispatchIDListField = $dispatchIDListField;
        return $this;
    }
    /**
     * Get routeIDListField value
     * @return \ArrayType\ArrayOfint|null
     */
    public function getRouteIDListField()
    {
        return $this->routeIDListField;
    }
    /**
     * Set routeIDListField value
     * @param \ArrayType\ArrayOfint $routeIDListField
     * @return \StructType\RouteSummaryReturnOptionsFilters
     */
    public function setRouteIDListField(\ArrayType\ArrayOfint $routeIDListField = null)
    {
        $this->routeIDListField = $routeIDListField;
        return $this;
    }
    /**
     * Get routeTypeField value
     * @return string|null
     */
    public function getRouteTypeField()
    {
        return $this->routeTypeField;
    }
    /**
     * Set routeTypeField value
     * @uses \EnumType\RouteType::valueIsValid()
     * @uses \EnumType\RouteType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $routeTypeField
     * @return \StructType\RouteSummaryReturnOptionsFilters
     */
    public function setRouteTypeField($routeTypeField = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RouteType::valueIsValid($routeTypeField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RouteType', is_array($routeTypeField) ? implode(', ', $routeTypeField) : var_export($routeTypeField, true), implode(', ', \EnumType\RouteType::getValidValues())), __LINE__);
        }
        $this->routeTypeField = $routeTypeField;
        return $this;
    }
}
