<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PaginationByDateRangeAndPage StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PaginationByDateRangeAndPage
 * @subpackage Structs
 */
class PaginationByDateRangeAndPage extends PaginationByDateRange
{
    /**
     * The pageField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $pageField;
    /**
     * The totalAvailablePagesField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $totalAvailablePagesField;
    /**
     * Constructor method for PaginationByDateRangeAndPage
     * @uses PaginationByDateRangeAndPage::setPageField()
     * @uses PaginationByDateRangeAndPage::setTotalAvailablePagesField()
     * @param int $pageField
     * @param int $totalAvailablePagesField
     */
    public function __construct($pageField = null, $totalAvailablePagesField = null)
    {
        $this
            ->setPageField($pageField)
            ->setTotalAvailablePagesField($totalAvailablePagesField);
    }
    /**
     * Get pageField value
     * @return int|null
     */
    public function getPageField()
    {
        return $this->pageField;
    }
    /**
     * Set pageField value
     * @param int $pageField
     * @return \StructType\PaginationByDateRangeAndPage
     */
    public function setPageField($pageField = null)
    {
        // validation for constraint: int
        if (!is_null($pageField) && !(is_int($pageField) || ctype_digit($pageField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($pageField, true), gettype($pageField)), __LINE__);
        }
        $this->pageField = $pageField;
        return $this;
    }
    /**
     * Get totalAvailablePagesField value
     * @return int|null
     */
    public function getTotalAvailablePagesField()
    {
        return $this->totalAvailablePagesField;
    }
    /**
     * Set totalAvailablePagesField value
     * @param int $totalAvailablePagesField
     * @return \StructType\PaginationByDateRangeAndPage
     */
    public function setTotalAvailablePagesField($totalAvailablePagesField = null)
    {
        // validation for constraint: int
        if (!is_null($totalAvailablePagesField) && !(is_int($totalAvailablePagesField) || ctype_digit($totalAvailablePagesField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalAvailablePagesField, true), gettype($totalAvailablePagesField)), __LINE__);
        }
        $this->totalAvailablePagesField = $totalAvailablePagesField;
        return $this;
    }
}
