<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OverTime StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OverTime
 * @subpackage Structs
 */
class OverTime extends AbstractStructBase
{
    /**
     * The costField
     * @var float
     */
    public $costField;
    /**
     * The hoursField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $hoursField;
    /**
     * Constructor method for OverTime
     * @uses OverTime::setCostField()
     * @uses OverTime::setHoursField()
     * @param float $costField
     * @param string $hoursField
     */
    public function __construct($costField = null, $hoursField = null)
    {
        $this
            ->setCostField($costField)
            ->setHoursField($hoursField);
    }
    /**
     * Get costField value
     * @return float|null
     */
    public function getCostField()
    {
        return $this->costField;
    }
    /**
     * Set costField value
     * @param float $costField
     * @return \StructType\OverTime
     */
    public function setCostField($costField = null)
    {
        // validation for constraint: float
        if (!is_null($costField) && !(is_float($costField) || is_numeric($costField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($costField, true), gettype($costField)), __LINE__);
        }
        $this->costField = $costField;
        return $this;
    }
    /**
     * Get hoursField value
     * @return string|null
     */
    public function getHoursField()
    {
        return $this->hoursField;
    }
    /**
     * Set hoursField value
     * @param string $hoursField
     * @return \StructType\OverTime
     */
    public function setHoursField($hoursField = null)
    {
        // validation for constraint: string
        if (!is_null($hoursField) && !is_string($hoursField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hoursField, true), gettype($hoursField)), __LINE__);
        }
        $this->hoursField = $hoursField;
        return $this;
    }
}
