<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderBaseType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OrderBaseType
 * @subpackage Structs
 */
class OrderBaseType extends AbstractStructBase
{
    /**
     * The accountIDField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $accountIDField;
    /**
     * The lineItemListField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfLineItemType
     */
    public $lineItemListField;
    /**
     * The orderIDField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $orderIDField;
    /**
     * The orderKeyIDField
     * @var int
     */
    public $orderKeyIDField;
    /**
     * Constructor method for OrderBaseType
     * @uses OrderBaseType::setAccountIDField()
     * @uses OrderBaseType::setLineItemListField()
     * @uses OrderBaseType::setOrderIDField()
     * @uses OrderBaseType::setOrderKeyIDField()
     * @param string $accountIDField
     * @param \ArrayType\ArrayOfLineItemType $lineItemListField
     * @param string $orderIDField
     * @param int $orderKeyIDField
     */
    public function __construct($accountIDField = null, \ArrayType\ArrayOfLineItemType $lineItemListField = null, $orderIDField = null, $orderKeyIDField = null)
    {
        $this
            ->setAccountIDField($accountIDField)
            ->setLineItemListField($lineItemListField)
            ->setOrderIDField($orderIDField)
            ->setOrderKeyIDField($orderKeyIDField);
    }
    /**
     * Get accountIDField value
     * @return string|null
     */
    public function getAccountIDField()
    {
        return $this->accountIDField;
    }
    /**
     * Set accountIDField value
     * @param string $accountIDField
     * @return \StructType\OrderBaseType
     */
    public function setAccountIDField($accountIDField = null)
    {
        // validation for constraint: string
        if (!is_null($accountIDField) && !is_string($accountIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountIDField, true), gettype($accountIDField)), __LINE__);
        }
        $this->accountIDField = $accountIDField;
        return $this;
    }
    /**
     * Get lineItemListField value
     * @return \ArrayType\ArrayOfLineItemType|null
     */
    public function getLineItemListField()
    {
        return $this->lineItemListField;
    }
    /**
     * Set lineItemListField value
     * @param \ArrayType\ArrayOfLineItemType $lineItemListField
     * @return \StructType\OrderBaseType
     */
    public function setLineItemListField(\ArrayType\ArrayOfLineItemType $lineItemListField = null)
    {
        $this->lineItemListField = $lineItemListField;
        return $this;
    }
    /**
     * Get orderIDField value
     * @return string|null
     */
    public function getOrderIDField()
    {
        return $this->orderIDField;
    }
    /**
     * Set orderIDField value
     * @param string $orderIDField
     * @return \StructType\OrderBaseType
     */
    public function setOrderIDField($orderIDField = null)
    {
        // validation for constraint: string
        if (!is_null($orderIDField) && !is_string($orderIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderIDField, true), gettype($orderIDField)), __LINE__);
        }
        $this->orderIDField = $orderIDField;
        return $this;
    }
    /**
     * Get orderKeyIDField value
     * @return int|null
     */
    public function getOrderKeyIDField()
    {
        return $this->orderKeyIDField;
    }
    /**
     * Set orderKeyIDField value
     * @param int $orderKeyIDField
     * @return \StructType\OrderBaseType
     */
    public function setOrderKeyIDField($orderKeyIDField = null)
    {
        // validation for constraint: int
        if (!is_null($orderKeyIDField) && !(is_int($orderKeyIDField) || ctype_digit($orderKeyIDField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderKeyIDField, true), gettype($orderKeyIDField)), __LINE__);
        }
        $this->orderKeyIDField = $orderKeyIDField;
        return $this;
    }
}
