<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Leg StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Leg
 * @subpackage Structs
 */
class Leg extends AbstractStructBase
{
    /**
     * The eventRecordsField
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfEventRecords
     */
    public $eventRecordsField;
    /**
     * The legNumField
     * @var int
     */
    public $legNumField;
    /**
     * The legNumFieldSpecified
     * @var bool
     */
    public $legNumFieldSpecified;
    /**
     * The statisticsField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\Statistics
     */
    public $statisticsField;
    /**
     * The stopField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfStop
     */
    public $stopField;
    /**
     * Constructor method for Leg
     * @uses Leg::setEventRecordsField()
     * @uses Leg::setLegNumField()
     * @uses Leg::setLegNumFieldSpecified()
     * @uses Leg::setStatisticsField()
     * @uses Leg::setStopField()
     * @param \ArrayType\ArrayOfEventRecords $eventRecordsField
     * @param int $legNumField
     * @param bool $legNumFieldSpecified
     * @param \StructType\Statistics $statisticsField
     * @param \ArrayType\ArrayOfStop $stopField
     */
    public function __construct(\ArrayType\ArrayOfEventRecords $eventRecordsField = null, $legNumField = null, $legNumFieldSpecified = null, \StructType\Statistics $statisticsField = null, \ArrayType\ArrayOfStop $stopField = null)
    {
        $this
            ->setEventRecordsField($eventRecordsField)
            ->setLegNumField($legNumField)
            ->setLegNumFieldSpecified($legNumFieldSpecified)
            ->setStatisticsField($statisticsField)
            ->setStopField($stopField);
    }
    /**
     * Get eventRecordsField value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfEventRecords|null
     */
    public function getEventRecordsField()
    {
        return isset($this->eventRecordsField) ? $this->eventRecordsField : null;
    }
    /**
     * Set eventRecordsField value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfEventRecords $eventRecordsField
     * @return \StructType\Leg
     */
    public function setEventRecordsField(\ArrayType\ArrayOfEventRecords $eventRecordsField = null)
    {
        if (is_null($eventRecordsField) || (is_array($eventRecordsField) && empty($eventRecordsField))) {
            unset($this->eventRecordsField);
        } else {
            $this->eventRecordsField = $eventRecordsField;
        }
        return $this;
    }
    /**
     * Get legNumField value
     * @return int|null
     */
    public function getLegNumField()
    {
        return $this->legNumField;
    }
    /**
     * Set legNumField value
     * @param int $legNumField
     * @return \StructType\Leg
     */
    public function setLegNumField($legNumField = null)
    {
        // validation for constraint: int
        if (!is_null($legNumField) && !(is_int($legNumField) || ctype_digit($legNumField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($legNumField, true), gettype($legNumField)), __LINE__);
        }
        $this->legNumField = $legNumField;
        return $this;
    }
    /**
     * Get legNumFieldSpecified value
     * @return bool|null
     */
    public function getLegNumFieldSpecified()
    {
        return $this->legNumFieldSpecified;
    }
    /**
     * Set legNumFieldSpecified value
     * @param bool $legNumFieldSpecified
     * @return \StructType\Leg
     */
    public function setLegNumFieldSpecified($legNumFieldSpecified = null)
    {
        // validation for constraint: boolean
        if (!is_null($legNumFieldSpecified) && !is_bool($legNumFieldSpecified)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($legNumFieldSpecified, true), gettype($legNumFieldSpecified)), __LINE__);
        }
        $this->legNumFieldSpecified = $legNumFieldSpecified;
        return $this;
    }
    /**
     * Get statisticsField value
     * @return \StructType\Statistics|null
     */
    public function getStatisticsField()
    {
        return $this->statisticsField;
    }
    /**
     * Set statisticsField value
     * @param \StructType\Statistics $statisticsField
     * @return \StructType\Leg
     */
    public function setStatisticsField(\StructType\Statistics $statisticsField = null)
    {
        $this->statisticsField = $statisticsField;
        return $this;
    }
    /**
     * Get stopField value
     * @return \ArrayType\ArrayOfStop|null
     */
    public function getStopField()
    {
        return $this->stopField;
    }
    /**
     * Set stopField value
     * @param \ArrayType\ArrayOfStop $stopField
     * @return \StructType\Leg
     */
    public function setStopField(\ArrayType\ArrayOfStop $stopField = null)
    {
        $this->stopField = $stopField;
        return $this;
    }
}
