<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FormItemType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FormItemType
 * @subpackage Structs
 */
class FormItemType extends AbstractStructBase
{
    /**
     * The dataTypeField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $dataTypeField;
    /**
     * The nameField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $nameField;
    /**
     * The optionsField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $optionsField;
    /**
     * Constructor method for FormItemType
     * @uses FormItemType::setDataTypeField()
     * @uses FormItemType::setNameField()
     * @uses FormItemType::setOptionsField()
     * @param string $dataTypeField
     * @param string $nameField
     * @param \ArrayType\ArrayOfstring $optionsField
     */
    public function __construct($dataTypeField = null, $nameField = null, \ArrayType\ArrayOfstring $optionsField = null)
    {
        $this
            ->setDataTypeField($dataTypeField)
            ->setNameField($nameField)
            ->setOptionsField($optionsField);
    }
    /**
     * Get dataTypeField value
     * @return string|null
     */
    public function getDataTypeField()
    {
        return $this->dataTypeField;
    }
    /**
     * Set dataTypeField value
     * @param string $dataTypeField
     * @return \StructType\FormItemType
     */
    public function setDataTypeField($dataTypeField = null)
    {
        // validation for constraint: string
        if (!is_null($dataTypeField) && !is_string($dataTypeField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataTypeField, true), gettype($dataTypeField)), __LINE__);
        }
        $this->dataTypeField = $dataTypeField;
        return $this;
    }
    /**
     * Get nameField value
     * @return string|null
     */
    public function getNameField()
    {
        return $this->nameField;
    }
    /**
     * Set nameField value
     * @param string $nameField
     * @return \StructType\FormItemType
     */
    public function setNameField($nameField = null)
    {
        // validation for constraint: string
        if (!is_null($nameField) && !is_string($nameField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameField, true), gettype($nameField)), __LINE__);
        }
        $this->nameField = $nameField;
        return $this;
    }
    /**
     * Get optionsField value
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getOptionsField()
    {
        return $this->optionsField;
    }
    /**
     * Set optionsField value
     * @param \ArrayType\ArrayOfstring $optionsField
     * @return \StructType\FormItemType
     */
    public function setOptionsField(\ArrayType\ArrayOfstring $optionsField = null)
    {
        $this->optionsField = $optionsField;
        return $this;
    }
}
