<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FormDetailListFormDetail StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FormDetailListFormDetail
 * @subpackage Structs
 */
class FormDetailListFormDetail extends AbstractStructBase
{
    /**
     * The formTypeField
     * @var string
     */
    public $formTypeField;
    /**
     * The itemListField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfFormItemType
     */
    public $itemListField;
    /**
     * The nameField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $nameField;
    /**
     * Constructor method for FormDetailListFormDetail
     * @uses FormDetailListFormDetail::setFormTypeField()
     * @uses FormDetailListFormDetail::setItemListField()
     * @uses FormDetailListFormDetail::setNameField()
     * @param string $formTypeField
     * @param \ArrayType\ArrayOfFormItemType $itemListField
     * @param string $nameField
     */
    public function __construct($formTypeField = null, \ArrayType\ArrayOfFormItemType $itemListField = null, $nameField = null)
    {
        $this
            ->setFormTypeField($formTypeField)
            ->setItemListField($itemListField)
            ->setNameField($nameField);
    }
    /**
     * Get formTypeField value
     * @return string|null
     */
    public function getFormTypeField()
    {
        return $this->formTypeField;
    }
    /**
     * Set formTypeField value
     * @uses \EnumType\FormType::valueIsValid()
     * @uses \EnumType\FormType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $formTypeField
     * @return \StructType\FormDetailListFormDetail
     */
    public function setFormTypeField($formTypeField = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\FormType::valueIsValid($formTypeField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\FormType', is_array($formTypeField) ? implode(', ', $formTypeField) : var_export($formTypeField, true), implode(', ', \EnumType\FormType::getValidValues())), __LINE__);
        }
        $this->formTypeField = $formTypeField;
        return $this;
    }
    /**
     * Get itemListField value
     * @return \ArrayType\ArrayOfFormItemType|null
     */
    public function getItemListField()
    {
        return $this->itemListField;
    }
    /**
     * Set itemListField value
     * @param \ArrayType\ArrayOfFormItemType $itemListField
     * @return \StructType\FormDetailListFormDetail
     */
    public function setItemListField(\ArrayType\ArrayOfFormItemType $itemListField = null)
    {
        $this->itemListField = $itemListField;
        return $this;
    }
    /**
     * Get nameField value
     * @return string|null
     */
    public function getNameField()
    {
        return $this->nameField;
    }
    /**
     * Set nameField value
     * @param string $nameField
     * @return \StructType\FormDetailListFormDetail
     */
    public function setNameField($nameField = null)
    {
        // validation for constraint: string
        if (!is_null($nameField) && !is_string($nameField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameField, true), gettype($nameField)), __LINE__);
        }
        $this->nameField = $nameField;
        return $this;
    }
}
