<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Form StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Form
 * @subpackage Structs
 */
class Form extends AbstractStructBase
{
    /**
     * The activityListField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfActivity
     */
    public $activityListField;
    /**
     * The activityValueField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $activityValueField;
    /**
     * The deviceFormTypeField
     * @var string
     */
    public $deviceFormTypeField;
    /**
     * The formNameField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $formNameField;
    /**
     * Constructor method for Form
     * @uses Form::setActivityListField()
     * @uses Form::setActivityValueField()
     * @uses Form::setDeviceFormTypeField()
     * @uses Form::setFormNameField()
     * @param \ArrayType\ArrayOfActivity $activityListField
     * @param string $activityValueField
     * @param string $deviceFormTypeField
     * @param string $formNameField
     */
    public function __construct(\ArrayType\ArrayOfActivity $activityListField = null, $activityValueField = null, $deviceFormTypeField = null, $formNameField = null)
    {
        $this
            ->setActivityListField($activityListField)
            ->setActivityValueField($activityValueField)
            ->setDeviceFormTypeField($deviceFormTypeField)
            ->setFormNameField($formNameField);
    }
    /**
     * Get activityListField value
     * @return \ArrayType\ArrayOfActivity|null
     */
    public function getActivityListField()
    {
        return $this->activityListField;
    }
    /**
     * Set activityListField value
     * @param \ArrayType\ArrayOfActivity $activityListField
     * @return \StructType\Form
     */
    public function setActivityListField(\ArrayType\ArrayOfActivity $activityListField = null)
    {
        $this->activityListField = $activityListField;
        return $this;
    }
    /**
     * Get activityValueField value
     * @return string|null
     */
    public function getActivityValueField()
    {
        return $this->activityValueField;
    }
    /**
     * Set activityValueField value
     * @param string $activityValueField
     * @return \StructType\Form
     */
    public function setActivityValueField($activityValueField = null)
    {
        // validation for constraint: string
        if (!is_null($activityValueField) && !is_string($activityValueField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityValueField, true), gettype($activityValueField)), __LINE__);
        }
        $this->activityValueField = $activityValueField;
        return $this;
    }
    /**
     * Get deviceFormTypeField value
     * @return string|null
     */
    public function getDeviceFormTypeField()
    {
        return $this->deviceFormTypeField;
    }
    /**
     * Set deviceFormTypeField value
     * @uses \EnumType\DeviceFormType::valueIsValid()
     * @uses \EnumType\DeviceFormType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $deviceFormTypeField
     * @return \StructType\Form
     */
    public function setDeviceFormTypeField($deviceFormTypeField = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\DeviceFormType::valueIsValid($deviceFormTypeField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\DeviceFormType', is_array($deviceFormTypeField) ? implode(', ', $deviceFormTypeField) : var_export($deviceFormTypeField, true), implode(', ', \EnumType\DeviceFormType::getValidValues())), __LINE__);
        }
        $this->deviceFormTypeField = $deviceFormTypeField;
        return $this;
    }
    /**
     * Get formNameField value
     * @return string|null
     */
    public function getFormNameField()
    {
        return $this->formNameField;
    }
    /**
     * Set formNameField value
     * @param string $formNameField
     * @return \StructType\Form
     */
    public function setFormNameField($formNameField = null)
    {
        // validation for constraint: string
        if (!is_null($formNameField) && !is_string($formNameField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formNameField, true), gettype($formNameField)), __LINE__);
        }
        $this->formNameField = $formNameField;
        return $this;
    }
}
