<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssetTransferDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AssetTransferDetails
 * @subpackage Structs
 */
class AssetTransferDetails extends AbstractStructBase
{
    /**
     * The assetIDField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $assetIDField;
    /**
     * The destinationBranchIDField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $destinationBranchIDField;
    /**
     * The effectiveDateField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $effectiveDateField;
    /**
     * The sourceBranchIDField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $sourceBranchIDField;
    /**
     * Constructor method for AssetTransferDetails
     * @uses AssetTransferDetails::setAssetIDField()
     * @uses AssetTransferDetails::setDestinationBranchIDField()
     * @uses AssetTransferDetails::setEffectiveDateField()
     * @uses AssetTransferDetails::setSourceBranchIDField()
     * @param string $assetIDField
     * @param string $destinationBranchIDField
     * @param string $effectiveDateField
     * @param string $sourceBranchIDField
     */
    public function __construct($assetIDField = null, $destinationBranchIDField = null, $effectiveDateField = null, $sourceBranchIDField = null)
    {
        $this
            ->setAssetIDField($assetIDField)
            ->setDestinationBranchIDField($destinationBranchIDField)
            ->setEffectiveDateField($effectiveDateField)
            ->setSourceBranchIDField($sourceBranchIDField);
    }
    /**
     * Get assetIDField value
     * @return string|null
     */
    public function getAssetIDField()
    {
        return $this->assetIDField;
    }
    /**
     * Set assetIDField value
     * @param string $assetIDField
     * @return \StructType\AssetTransferDetails
     */
    public function setAssetIDField($assetIDField = null)
    {
        // validation for constraint: string
        if (!is_null($assetIDField) && !is_string($assetIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assetIDField, true), gettype($assetIDField)), __LINE__);
        }
        $this->assetIDField = $assetIDField;
        return $this;
    }
    /**
     * Get destinationBranchIDField value
     * @return string|null
     */
    public function getDestinationBranchIDField()
    {
        return $this->destinationBranchIDField;
    }
    /**
     * Set destinationBranchIDField value
     * @param string $destinationBranchIDField
     * @return \StructType\AssetTransferDetails
     */
    public function setDestinationBranchIDField($destinationBranchIDField = null)
    {
        // validation for constraint: string
        if (!is_null($destinationBranchIDField) && !is_string($destinationBranchIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($destinationBranchIDField, true), gettype($destinationBranchIDField)), __LINE__);
        }
        $this->destinationBranchIDField = $destinationBranchIDField;
        return $this;
    }
    /**
     * Get effectiveDateField value
     * @return string|null
     */
    public function getEffectiveDateField()
    {
        return $this->effectiveDateField;
    }
    /**
     * Set effectiveDateField value
     * @param string $effectiveDateField
     * @return \StructType\AssetTransferDetails
     */
    public function setEffectiveDateField($effectiveDateField = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveDateField) && !is_string($effectiveDateField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveDateField, true), gettype($effectiveDateField)), __LINE__);
        }
        $this->effectiveDateField = $effectiveDateField;
        return $this;
    }
    /**
     * Get sourceBranchIDField value
     * @return string|null
     */
    public function getSourceBranchIDField()
    {
        return $this->sourceBranchIDField;
    }
    /**
     * Set sourceBranchIDField value
     * @param string $sourceBranchIDField
     * @return \StructType\AssetTransferDetails
     */
    public function setSourceBranchIDField($sourceBranchIDField = null)
    {
        // validation for constraint: string
        if (!is_null($sourceBranchIDField) && !is_string($sourceBranchIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sourceBranchIDField, true), gettype($sourceBranchIDField)), __LINE__);
        }
        $this->sourceBranchIDField = $sourceBranchIDField;
        return $this;
    }
}
