<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddressType
 * @subpackage Structs
 */
class AddressType extends AbstractStructBase
{
    /**
     * The address1Field
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $address1Field;
    /**
     * The address2Field
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $address2Field;
    /**
     * The cityField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $cityField;
    /**
     * The coordinatesField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\Coordinates
     */
    public $coordinatesField;
    /**
     * The stateField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $stateField;
    /**
     * The zipCodeField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $zipCodeField;
    /**
     * Constructor method for AddressType
     * @uses AddressType::setAddress1Field()
     * @uses AddressType::setAddress2Field()
     * @uses AddressType::setCityField()
     * @uses AddressType::setCoordinatesField()
     * @uses AddressType::setStateField()
     * @uses AddressType::setZipCodeField()
     * @param string $address1Field
     * @param string $address2Field
     * @param string $cityField
     * @param \StructType\Coordinates $coordinatesField
     * @param string $stateField
     * @param string $zipCodeField
     */
    public function __construct($address1Field = null, $address2Field = null, $cityField = null, \StructType\Coordinates $coordinatesField = null, $stateField = null, $zipCodeField = null)
    {
        $this
            ->setAddress1Field($address1Field)
            ->setAddress2Field($address2Field)
            ->setCityField($cityField)
            ->setCoordinatesField($coordinatesField)
            ->setStateField($stateField)
            ->setZipCodeField($zipCodeField);
    }
    /**
     * Get address1Field value
     * @return string|null
     */
    public function getAddress1Field()
    {
        return $this->address1Field;
    }
    /**
     * Set address1Field value
     * @param string $address1Field
     * @return \StructType\AddressType
     */
    public function setAddress1Field($address1Field = null)
    {
        // validation for constraint: string
        if (!is_null($address1Field) && !is_string($address1Field)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address1Field, true), gettype($address1Field)), __LINE__);
        }
        $this->address1Field = $address1Field;
        return $this;
    }
    /**
     * Get address2Field value
     * @return string|null
     */
    public function getAddress2Field()
    {
        return $this->address2Field;
    }
    /**
     * Set address2Field value
     * @param string $address2Field
     * @return \StructType\AddressType
     */
    public function setAddress2Field($address2Field = null)
    {
        // validation for constraint: string
        if (!is_null($address2Field) && !is_string($address2Field)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($address2Field, true), gettype($address2Field)), __LINE__);
        }
        $this->address2Field = $address2Field;
        return $this;
    }
    /**
     * Get cityField value
     * @return string|null
     */
    public function getCityField()
    {
        return $this->cityField;
    }
    /**
     * Set cityField value
     * @param string $cityField
     * @return \StructType\AddressType
     */
    public function setCityField($cityField = null)
    {
        // validation for constraint: string
        if (!is_null($cityField) && !is_string($cityField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cityField, true), gettype($cityField)), __LINE__);
        }
        $this->cityField = $cityField;
        return $this;
    }
    /**
     * Get coordinatesField value
     * @return \StructType\Coordinates|null
     */
    public function getCoordinatesField()
    {
        return $this->coordinatesField;
    }
    /**
     * Set coordinatesField value
     * @param \StructType\Coordinates $coordinatesField
     * @return \StructType\AddressType
     */
    public function setCoordinatesField(\StructType\Coordinates $coordinatesField = null)
    {
        $this->coordinatesField = $coordinatesField;
        return $this;
    }
    /**
     * Get stateField value
     * @return string|null
     */
    public function getStateField()
    {
        return $this->stateField;
    }
    /**
     * Set stateField value
     * @param string $stateField
     * @return \StructType\AddressType
     */
    public function setStateField($stateField = null)
    {
        // validation for constraint: string
        if (!is_null($stateField) && !is_string($stateField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stateField, true), gettype($stateField)), __LINE__);
        }
        $this->stateField = $stateField;
        return $this;
    }
    /**
     * Get zipCodeField value
     * @return string|null
     */
    public function getZipCodeField()
    {
        return $this->zipCodeField;
    }
    /**
     * Set zipCodeField value
     * @param string $zipCodeField
     * @return \StructType\AddressType
     */
    public function setZipCodeField($zipCodeField = null)
    {
        // validation for constraint: string
        if (!is_null($zipCodeField) && !is_string($zipCodeField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($zipCodeField, true), gettype($zipCodeField)), __LINE__);
        }
        $this->zipCodeField = $zipCodeField;
        return $this;
    }
}
