<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Activity StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Activity
 * @subpackage Structs
 */
class Activity extends AbstractStructBase
{
    /**
     * The activityNameField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $activityNameField;
    /**
     * The activityTimeField
     * @var string
     */
    public $activityTimeField;
    /**
     * The activityValueField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $activityValueField;
    /**
     * Constructor method for Activity
     * @uses Activity::setActivityNameField()
     * @uses Activity::setActivityTimeField()
     * @uses Activity::setActivityValueField()
     * @param string $activityNameField
     * @param string $activityTimeField
     * @param string $activityValueField
     */
    public function __construct($activityNameField = null, $activityTimeField = null, $activityValueField = null)
    {
        $this
            ->setActivityNameField($activityNameField)
            ->setActivityTimeField($activityTimeField)
            ->setActivityValueField($activityValueField);
    }
    /**
     * Get activityNameField value
     * @return string|null
     */
    public function getActivityNameField()
    {
        return $this->activityNameField;
    }
    /**
     * Set activityNameField value
     * @param string $activityNameField
     * @return \StructType\Activity
     */
    public function setActivityNameField($activityNameField = null)
    {
        // validation for constraint: string
        if (!is_null($activityNameField) && !is_string($activityNameField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityNameField, true), gettype($activityNameField)), __LINE__);
        }
        $this->activityNameField = $activityNameField;
        return $this;
    }
    /**
     * Get activityTimeField value
     * @return string|null
     */
    public function getActivityTimeField()
    {
        return $this->activityTimeField;
    }
    /**
     * Set activityTimeField value
     * @param string $activityTimeField
     * @return \StructType\Activity
     */
    public function setActivityTimeField($activityTimeField = null)
    {
        // validation for constraint: string
        if (!is_null($activityTimeField) && !is_string($activityTimeField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityTimeField, true), gettype($activityTimeField)), __LINE__);
        }
        $this->activityTimeField = $activityTimeField;
        return $this;
    }
    /**
     * Get activityValueField value
     * @return string|null
     */
    public function getActivityValueField()
    {
        return $this->activityValueField;
    }
    /**
     * Set activityValueField value
     * @param string $activityValueField
     * @return \StructType\Activity
     */
    public function setActivityValueField($activityValueField = null)
    {
        // validation for constraint: string
        if (!is_null($activityValueField) && !is_string($activityValueField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activityValueField, true), gettype($activityValueField)), __LINE__);
        }
        $this->activityValueField = $activityValueField;
        return $this;
    }
}
