<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountEmailEvent StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AccountEmailEvent
 * @subpackage Structs
 */
class AccountEmailEvent extends AbstractStructBase
{
    /**
     * The Command
     * @var string
     */
    public $Command;
    /**
     * The Event
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Event;
    /**
     * The lstEmailPerson
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfEmailPerson
     */
    public $lstEmailPerson;
    /**
     * Constructor method for AccountEmailEvent
     * @uses AccountEmailEvent::setCommand()
     * @uses AccountEmailEvent::setEvent()
     * @uses AccountEmailEvent::setLstEmailPerson()
     * @param string $command
     * @param string $event
     * @param \ArrayType\ArrayOfEmailPerson $lstEmailPerson
     */
    public function __construct($command = null, $event = null, \ArrayType\ArrayOfEmailPerson $lstEmailPerson = null)
    {
        $this
            ->setCommand($command)
            ->setEvent($event)
            ->setLstEmailPerson($lstEmailPerson);
    }
    /**
     * Get Command value
     * @return string|null
     */
    public function getCommand()
    {
        return $this->Command;
    }
    /**
     * Set Command value
     * @uses \EnumType\AccountEmailCommand::valueIsValid()
     * @uses \EnumType\AccountEmailCommand::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $command
     * @return \StructType\AccountEmailEvent
     */
    public function setCommand($command = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AccountEmailCommand::valueIsValid($command)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\AccountEmailCommand', is_array($command) ? implode(', ', $command) : var_export($command, true), implode(', ', \EnumType\AccountEmailCommand::getValidValues())), __LINE__);
        }
        $this->Command = $command;
        return $this;
    }
    /**
     * Get Event value
     * @return string|null
     */
    public function getEvent()
    {
        return $this->Event;
    }
    /**
     * Set Event value
     * @param string $event
     * @return \StructType\AccountEmailEvent
     */
    public function setEvent($event = null)
    {
        // validation for constraint: string
        if (!is_null($event) && !is_string($event)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($event, true), gettype($event)), __LINE__);
        }
        $this->Event = $event;
        return $this;
    }
    /**
     * Get lstEmailPerson value
     * @return \ArrayType\ArrayOfEmailPerson|null
     */
    public function getLstEmailPerson()
    {
        return $this->lstEmailPerson;
    }
    /**
     * Set lstEmailPerson value
     * @param \ArrayType\ArrayOfEmailPerson $lstEmailPerson
     * @return \StructType\AccountEmailEvent
     */
    public function setLstEmailPerson(\ArrayType\ArrayOfEmailPerson $lstEmailPerson = null)
    {
        $this->lstEmailPerson = $lstEmailPerson;
        return $this;
    }
}
