<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Unload ServiceType
 * @subpackage Services
 */
class Unload extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named UnloadOrders
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\UnloadOrders $parameters
     * @return \StructType\UnloadOrdersResponse|bool
     */
    public function UnloadOrders(\StructType\UnloadOrders $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->UnloadOrders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\UnloadOrdersResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
