<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Import ServiceType
 * @subpackage Services
 */
class Import extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ImportActuals
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImportActuals $parameters
     * @return \StructType\ImportActualsResponse|bool
     */
    public function ImportActuals(\StructType\ImportActuals $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ImportActuals($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ImportActualsFromMultipleBranches
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImportActualsFromMultipleBranches $parameters
     * @return \StructType\ImportActualsFromMultipleBranchesResponse|bool
     */
    public function ImportActualsFromMultipleBranches(\StructType\ImportActualsFromMultipleBranches $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ImportActualsFromMultipleBranches($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ImportOrders
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImportOrders $parameters
     * @return \StructType\ImportOrdersResponse|bool
     */
    public function ImportOrders(\StructType\ImportOrders $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ImportOrders($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ImportExtractFile
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImportExtractFile $parameters
     * @return \StructType\ImportExtractFileResponse|bool
     */
    public function ImportExtractFile(\StructType\ImportExtractFile $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ImportExtractFile($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ImportRoutes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImportRoutes $parameters
     * @return \StructType\ImportRoutesResponse|bool
     */
    public function ImportRoutes(\StructType\ImportRoutes $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ImportRoutes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ImportDrivers
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImportDrivers $parameters
     * @return \StructType\ImportDriversResponse|bool
     */
    public function ImportDrivers(\StructType\ImportDrivers $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ImportDrivers($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ImportDevices
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImportDevices $parameters
     * @return \StructType\ImportDevicesResponse|bool
     */
    public function ImportDevices(\StructType\ImportDevices $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ImportDevices($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ImportAccounts
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImportAccounts $parameters
     * @return \StructType\ImportAccountsResponse|bool
     */
    public function ImportAccounts(\StructType\ImportAccounts $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ImportAccounts($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ImportBranches
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImportBranches $parameters
     * @return \StructType\ImportBranchesResponse|bool
     */
    public function ImportBranches(\StructType\ImportBranches $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ImportBranches($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ImportAssets
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImportAssets $parameters
     * @return \StructType\ImportAssetsResponse|bool
     */
    public function ImportAssets(\StructType\ImportAssets $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ImportAssets($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ImportCostingRules
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImportCostingRules $parameters
     * @return \StructType\ImportCostingRulesResponse|bool
     */
    public function ImportCostingRules(\StructType\ImportCostingRules $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->ImportCostingRules($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ImportAccountsResponse|\StructType\ImportActualsFromMultipleBranchesResponse|\StructType\ImportActualsResponse|\StructType\ImportAssetsResponse|\StructType\ImportBranchesResponse|\StructType\ImportCostingRulesResponse|\StructType\ImportDevicesResponse|\StructType\ImportDriversResponse|\StructType\ImportExtractFileResponse|\StructType\ImportOrdersResponse|\StructType\ImportRoutesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
