<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfVolume ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfVolume
 * @subpackage Arrays
 */
class ArrayOfVolume extends AbstractStructArrayBase
{
    /**
     * The Volume
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Volume[]
     */
    public $Volume;
    /**
     * Constructor method for ArrayOfVolume
     * @uses ArrayOfVolume::setVolume()
     * @param \StructType\Volume[] $volume
     */
    public function __construct(array $volume = array())
    {
        $this
            ->setVolume($volume);
    }
    /**
     * Get Volume value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Volume[]|null
     */
    public function getVolume()
    {
        return isset($this->Volume) ? $this->Volume : null;
    }
    /**
     * This method is responsible for validating the values passed to the setVolume method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVolume method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVolumeForArrayConstraintsFromSetVolume(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfVolumeVolumeItem) {
            // validation for constraint: itemType
            if (!$arrayOfVolumeVolumeItem instanceof \StructType\Volume) {
                $invalidValues[] = is_object($arrayOfVolumeVolumeItem) ? get_class($arrayOfVolumeVolumeItem) : sprintf('%s(%s)', gettype($arrayOfVolumeVolumeItem), var_export($arrayOfVolumeVolumeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Volume property can only contain items of type \StructType\Volume, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Volume value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Volume[] $volume
     * @return \ArrayType\ArrayOfVolume
     */
    public function setVolume(array $volume = array())
    {
        // validation for constraint: array
        if ('' !== ($volumeArrayErrorMessage = self::validateVolumeForArrayConstraintsFromSetVolume($volume))) {
            throw new \InvalidArgumentException($volumeArrayErrorMessage, __LINE__);
        }
        if (is_null($volume) || (is_array($volume) && empty($volume))) {
            unset($this->Volume);
        } else {
            $this->Volume = $volume;
        }
        return $this;
    }
    /**
     * Add item to Volume value
     * @throws \InvalidArgumentException
     * @param \StructType\Volume $item
     * @return \ArrayType\ArrayOfVolume
     */
    public function addToVolume(\StructType\Volume $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Volume) {
            throw new \InvalidArgumentException(sprintf('The Volume property can only contain items of type \StructType\Volume, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Volume[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Volume|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Volume|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Volume|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Volume|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Volume|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Volume
     */
    public function getAttributeName()
    {
        return 'Volume';
    }
}
