<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfTimeWindow ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfTimeWindow
 * @subpackage Arrays
 */
class ArrayOfTimeWindow extends AbstractStructArrayBase
{
    /**
     * The TimeWindow
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\TimeWindow[]
     */
    public $TimeWindow;
    /**
     * Constructor method for ArrayOfTimeWindow
     * @uses ArrayOfTimeWindow::setTimeWindow()
     * @param \StructType\TimeWindow[] $timeWindow
     */
    public function __construct(array $timeWindow = array())
    {
        $this
            ->setTimeWindow($timeWindow);
    }
    /**
     * Get TimeWindow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\TimeWindow[]|null
     */
    public function getTimeWindow()
    {
        return isset($this->TimeWindow) ? $this->TimeWindow : null;
    }
    /**
     * This method is responsible for validating the values passed to the setTimeWindow method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTimeWindow method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTimeWindowForArrayConstraintsFromSetTimeWindow(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfTimeWindowTimeWindowItem) {
            // validation for constraint: itemType
            if (!$arrayOfTimeWindowTimeWindowItem instanceof \StructType\TimeWindow) {
                $invalidValues[] = is_object($arrayOfTimeWindowTimeWindowItem) ? get_class($arrayOfTimeWindowTimeWindowItem) : sprintf('%s(%s)', gettype($arrayOfTimeWindowTimeWindowItem), var_export($arrayOfTimeWindowTimeWindowItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The TimeWindow property can only contain items of type \StructType\TimeWindow, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set TimeWindow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\TimeWindow[] $timeWindow
     * @return \ArrayType\ArrayOfTimeWindow
     */
    public function setTimeWindow(array $timeWindow = array())
    {
        // validation for constraint: array
        if ('' !== ($timeWindowArrayErrorMessage = self::validateTimeWindowForArrayConstraintsFromSetTimeWindow($timeWindow))) {
            throw new \InvalidArgumentException($timeWindowArrayErrorMessage, __LINE__);
        }
        if (is_null($timeWindow) || (is_array($timeWindow) && empty($timeWindow))) {
            unset($this->TimeWindow);
        } else {
            $this->TimeWindow = $timeWindow;
        }
        return $this;
    }
    /**
     * Add item to TimeWindow value
     * @throws \InvalidArgumentException
     * @param \StructType\TimeWindow $item
     * @return \ArrayType\ArrayOfTimeWindow
     */
    public function addToTimeWindow(\StructType\TimeWindow $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TimeWindow) {
            throw new \InvalidArgumentException(sprintf('The TimeWindow property can only contain items of type \StructType\TimeWindow, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->TimeWindow[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\TimeWindow|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\TimeWindow|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\TimeWindow|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\TimeWindow|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\TimeWindow|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string TimeWindow
     */
    public function getAttributeName()
    {
        return 'TimeWindow';
    }
}
