<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfStop ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfStop
 * @subpackage Arrays
 */
class ArrayOfStop extends AbstractStructArrayBase
{
    /**
     * The Stop
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Stop[]
     */
    public $Stop;
    /**
     * Constructor method for ArrayOfStop
     * @uses ArrayOfStop::setStop()
     * @param \StructType\Stop[] $stop
     */
    public function __construct(array $stop = array())
    {
        $this
            ->setStop($stop);
    }
    /**
     * Get Stop value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Stop[]|null
     */
    public function getStop()
    {
        return isset($this->Stop) ? $this->Stop : null;
    }
    /**
     * This method is responsible for validating the values passed to the setStop method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStop method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStopForArrayConstraintsFromSetStop(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfStopStopItem) {
            // validation for constraint: itemType
            if (!$arrayOfStopStopItem instanceof \StructType\Stop) {
                $invalidValues[] = is_object($arrayOfStopStopItem) ? get_class($arrayOfStopStopItem) : sprintf('%s(%s)', gettype($arrayOfStopStopItem), var_export($arrayOfStopStopItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Stop property can only contain items of type \StructType\Stop, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Stop value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Stop[] $stop
     * @return \ArrayType\ArrayOfStop
     */
    public function setStop(array $stop = array())
    {
        // validation for constraint: array
        if ('' !== ($stopArrayErrorMessage = self::validateStopForArrayConstraintsFromSetStop($stop))) {
            throw new \InvalidArgumentException($stopArrayErrorMessage, __LINE__);
        }
        if (is_null($stop) || (is_array($stop) && empty($stop))) {
            unset($this->Stop);
        } else {
            $this->Stop = $stop;
        }
        return $this;
    }
    /**
     * Add item to Stop value
     * @throws \InvalidArgumentException
     * @param \StructType\Stop $item
     * @return \ArrayType\ArrayOfStop
     */
    public function addToStop(\StructType\Stop $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Stop) {
            throw new \InvalidArgumentException(sprintf('The Stop property can only contain items of type \StructType\Stop, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Stop[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Stop|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Stop|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Stop|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Stop|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Stop|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Stop
     */
    public function getAttributeName()
    {
        return 'Stop';
    }
}
