<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfOrderFormInfo ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfOrderFormInfo
 * @subpackage Arrays
 */
class ArrayOfOrderFormInfo extends AbstractStructArrayBase
{
    /**
     * The OrderFormInfo
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\OrderFormInfo[]
     */
    public $OrderFormInfo;
    /**
     * Constructor method for ArrayOfOrderFormInfo
     * @uses ArrayOfOrderFormInfo::setOrderFormInfo()
     * @param \StructType\OrderFormInfo[] $orderFormInfo
     */
    public function __construct(array $orderFormInfo = array())
    {
        $this
            ->setOrderFormInfo($orderFormInfo);
    }
    /**
     * Get OrderFormInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\OrderFormInfo[]|null
     */
    public function getOrderFormInfo()
    {
        return isset($this->OrderFormInfo) ? $this->OrderFormInfo : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOrderFormInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOrderFormInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOrderFormInfoForArrayConstraintsFromSetOrderFormInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfOrderFormInfoOrderFormInfoItem) {
            // validation for constraint: itemType
            if (!$arrayOfOrderFormInfoOrderFormInfoItem instanceof \StructType\OrderFormInfo) {
                $invalidValues[] = is_object($arrayOfOrderFormInfoOrderFormInfoItem) ? get_class($arrayOfOrderFormInfoOrderFormInfoItem) : sprintf('%s(%s)', gettype($arrayOfOrderFormInfoOrderFormInfoItem), var_export($arrayOfOrderFormInfoOrderFormInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OrderFormInfo property can only contain items of type \StructType\OrderFormInfo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OrderFormInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OrderFormInfo[] $orderFormInfo
     * @return \ArrayType\ArrayOfOrderFormInfo
     */
    public function setOrderFormInfo(array $orderFormInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($orderFormInfoArrayErrorMessage = self::validateOrderFormInfoForArrayConstraintsFromSetOrderFormInfo($orderFormInfo))) {
            throw new \InvalidArgumentException($orderFormInfoArrayErrorMessage, __LINE__);
        }
        if (is_null($orderFormInfo) || (is_array($orderFormInfo) && empty($orderFormInfo))) {
            unset($this->OrderFormInfo);
        } else {
            $this->OrderFormInfo = $orderFormInfo;
        }
        return $this;
    }
    /**
     * Add item to OrderFormInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\OrderFormInfo $item
     * @return \ArrayType\ArrayOfOrderFormInfo
     */
    public function addToOrderFormInfo(\StructType\OrderFormInfo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OrderFormInfo) {
            throw new \InvalidArgumentException(sprintf('The OrderFormInfo property can only contain items of type \StructType\OrderFormInfo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OrderFormInfo[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\OrderFormInfo|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\OrderFormInfo|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\OrderFormInfo|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\OrderFormInfo|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\OrderFormInfo|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string OrderFormInfo
     */
    public function getAttributeName()
    {
        return 'OrderFormInfo';
    }
}
