<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLineItemDetailActualType ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfLineItemDetailActualType
 * @subpackage Arrays
 */
class ArrayOfLineItemDetailActualType extends AbstractStructArrayBase
{
    /**
     * The LineItemDetailActualType
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LineItemDetailActualType[]
     */
    public $LineItemDetailActualType;
    /**
     * Constructor method for ArrayOfLineItemDetailActualType
     * @uses ArrayOfLineItemDetailActualType::setLineItemDetailActualType()
     * @param \StructType\LineItemDetailActualType[] $lineItemDetailActualType
     */
    public function __construct(array $lineItemDetailActualType = array())
    {
        $this
            ->setLineItemDetailActualType($lineItemDetailActualType);
    }
    /**
     * Get LineItemDetailActualType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LineItemDetailActualType[]|null
     */
    public function getLineItemDetailActualType()
    {
        return isset($this->LineItemDetailActualType) ? $this->LineItemDetailActualType : null;
    }
    /**
     * This method is responsible for validating the values passed to the setLineItemDetailActualType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLineItemDetailActualType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLineItemDetailActualTypeForArrayConstraintsFromSetLineItemDetailActualType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfLineItemDetailActualTypeLineItemDetailActualTypeItem) {
            // validation for constraint: itemType
            if (!$arrayOfLineItemDetailActualTypeLineItemDetailActualTypeItem instanceof \StructType\LineItemDetailActualType) {
                $invalidValues[] = is_object($arrayOfLineItemDetailActualTypeLineItemDetailActualTypeItem) ? get_class($arrayOfLineItemDetailActualTypeLineItemDetailActualTypeItem) : sprintf('%s(%s)', gettype($arrayOfLineItemDetailActualTypeLineItemDetailActualTypeItem), var_export($arrayOfLineItemDetailActualTypeLineItemDetailActualTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The LineItemDetailActualType property can only contain items of type \StructType\LineItemDetailActualType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set LineItemDetailActualType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\LineItemDetailActualType[] $lineItemDetailActualType
     * @return \ArrayType\ArrayOfLineItemDetailActualType
     */
    public function setLineItemDetailActualType(array $lineItemDetailActualType = array())
    {
        // validation for constraint: array
        if ('' !== ($lineItemDetailActualTypeArrayErrorMessage = self::validateLineItemDetailActualTypeForArrayConstraintsFromSetLineItemDetailActualType($lineItemDetailActualType))) {
            throw new \InvalidArgumentException($lineItemDetailActualTypeArrayErrorMessage, __LINE__);
        }
        if (is_null($lineItemDetailActualType) || (is_array($lineItemDetailActualType) && empty($lineItemDetailActualType))) {
            unset($this->LineItemDetailActualType);
        } else {
            $this->LineItemDetailActualType = $lineItemDetailActualType;
        }
        return $this;
    }
    /**
     * Add item to LineItemDetailActualType value
     * @throws \InvalidArgumentException
     * @param \StructType\LineItemDetailActualType $item
     * @return \ArrayType\ArrayOfLineItemDetailActualType
     */
    public function addToLineItemDetailActualType(\StructType\LineItemDetailActualType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LineItemDetailActualType) {
            throw new \InvalidArgumentException(sprintf('The LineItemDetailActualType property can only contain items of type \StructType\LineItemDetailActualType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->LineItemDetailActualType[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\LineItemDetailActualType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\LineItemDetailActualType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\LineItemDetailActualType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\LineItemDetailActualType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\LineItemDetailActualType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string LineItemDetailActualType
     */
    public function getAttributeName()
    {
        return 'LineItemDetailActualType';
    }
}
