<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfForm ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfForm
 * @subpackage Arrays
 */
class ArrayOfForm extends AbstractStructArrayBase
{
    /**
     * The Form
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Form[]
     */
    public $Form;
    /**
     * Constructor method for ArrayOfForm
     * @uses ArrayOfForm::setForm()
     * @param \StructType\Form[] $form
     */
    public function __construct(array $form = array())
    {
        $this
            ->setForm($form);
    }
    /**
     * Get Form value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Form[]|null
     */
    public function getForm()
    {
        return isset($this->Form) ? $this->Form : null;
    }
    /**
     * This method is responsible for validating the values passed to the setForm method
     * This method is willingly generated in order to preserve the one-line inline validation within the setForm method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFormForArrayConstraintsFromSetForm(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfFormFormItem) {
            // validation for constraint: itemType
            if (!$arrayOfFormFormItem instanceof \StructType\Form) {
                $invalidValues[] = is_object($arrayOfFormFormItem) ? get_class($arrayOfFormFormItem) : sprintf('%s(%s)', gettype($arrayOfFormFormItem), var_export($arrayOfFormFormItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Form property can only contain items of type \StructType\Form, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Form value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Form[] $form
     * @return \ArrayType\ArrayOfForm
     */
    public function setForm(array $form = array())
    {
        // validation for constraint: array
        if ('' !== ($formArrayErrorMessage = self::validateFormForArrayConstraintsFromSetForm($form))) {
            throw new \InvalidArgumentException($formArrayErrorMessage, __LINE__);
        }
        if (is_null($form) || (is_array($form) && empty($form))) {
            unset($this->Form);
        } else {
            $this->Form = $form;
        }
        return $this;
    }
    /**
     * Add item to Form value
     * @throws \InvalidArgumentException
     * @param \StructType\Form $item
     * @return \ArrayType\ArrayOfForm
     */
    public function addToForm(\StructType\Form $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Form) {
            throw new \InvalidArgumentException(sprintf('The Form property can only contain items of type \StructType\Form, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Form[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Form|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Form|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Form|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Form|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Form|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Form
     */
    public function getAttributeName()
    {
        return 'Form';
    }
}
