<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDeviceDetails ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfDeviceDetails
 * @subpackage Arrays
 */
class ArrayOfDeviceDetails extends AbstractStructArrayBase
{
    /**
     * The DeviceDetails
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DeviceDetails[]
     */
    public $DeviceDetails;
    /**
     * Constructor method for ArrayOfDeviceDetails
     * @uses ArrayOfDeviceDetails::setDeviceDetails()
     * @param \StructType\DeviceDetails[] $deviceDetails
     */
    public function __construct(array $deviceDetails = array())
    {
        $this
            ->setDeviceDetails($deviceDetails);
    }
    /**
     * Get DeviceDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DeviceDetails[]|null
     */
    public function getDeviceDetails()
    {
        return isset($this->DeviceDetails) ? $this->DeviceDetails : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDeviceDetails method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeviceDetails method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeviceDetailsForArrayConstraintsFromSetDeviceDetails(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDeviceDetailsDeviceDetailsItem) {
            // validation for constraint: itemType
            if (!$arrayOfDeviceDetailsDeviceDetailsItem instanceof \StructType\DeviceDetails) {
                $invalidValues[] = is_object($arrayOfDeviceDetailsDeviceDetailsItem) ? get_class($arrayOfDeviceDetailsDeviceDetailsItem) : sprintf('%s(%s)', gettype($arrayOfDeviceDetailsDeviceDetailsItem), var_export($arrayOfDeviceDetailsDeviceDetailsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DeviceDetails property can only contain items of type \StructType\DeviceDetails, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DeviceDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DeviceDetails[] $deviceDetails
     * @return \ArrayType\ArrayOfDeviceDetails
     */
    public function setDeviceDetails(array $deviceDetails = array())
    {
        // validation for constraint: array
        if ('' !== ($deviceDetailsArrayErrorMessage = self::validateDeviceDetailsForArrayConstraintsFromSetDeviceDetails($deviceDetails))) {
            throw new \InvalidArgumentException($deviceDetailsArrayErrorMessage, __LINE__);
        }
        if (is_null($deviceDetails) || (is_array($deviceDetails) && empty($deviceDetails))) {
            unset($this->DeviceDetails);
        } else {
            $this->DeviceDetails = $deviceDetails;
        }
        return $this;
    }
    /**
     * Add item to DeviceDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\DeviceDetails $item
     * @return \ArrayType\ArrayOfDeviceDetails
     */
    public function addToDeviceDetails(\StructType\DeviceDetails $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeviceDetails) {
            throw new \InvalidArgumentException(sprintf('The DeviceDetails property can only contain items of type \StructType\DeviceDetails, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DeviceDetails[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DeviceDetails|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DeviceDetails|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DeviceDetails|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DeviceDetails|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DeviceDetails|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DeviceDetails
     */
    public function getAttributeName()
    {
        return 'DeviceDetails';
    }
}
