<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfDeviceData ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfDeviceData
 * @subpackage Arrays
 */
class ArrayOfDeviceData extends AbstractStructArrayBase
{
    /**
     * The DeviceData
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\DeviceData[]
     */
    public $DeviceData;
    /**
     * Constructor method for ArrayOfDeviceData
     * @uses ArrayOfDeviceData::setDeviceData()
     * @param \StructType\DeviceData[] $deviceData
     */
    public function __construct(array $deviceData = array())
    {
        $this
            ->setDeviceData($deviceData);
    }
    /**
     * Get DeviceData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\DeviceData[]|null
     */
    public function getDeviceData()
    {
        return isset($this->DeviceData) ? $this->DeviceData : null;
    }
    /**
     * This method is responsible for validating the values passed to the setDeviceData method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDeviceData method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDeviceDataForArrayConstraintsFromSetDeviceData(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfDeviceDataDeviceDataItem) {
            // validation for constraint: itemType
            if (!$arrayOfDeviceDataDeviceDataItem instanceof \StructType\DeviceData) {
                $invalidValues[] = is_object($arrayOfDeviceDataDeviceDataItem) ? get_class($arrayOfDeviceDataDeviceDataItem) : sprintf('%s(%s)', gettype($arrayOfDeviceDataDeviceDataItem), var_export($arrayOfDeviceDataDeviceDataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DeviceData property can only contain items of type \StructType\DeviceData, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DeviceData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\DeviceData[] $deviceData
     * @return \ArrayType\ArrayOfDeviceData
     */
    public function setDeviceData(array $deviceData = array())
    {
        // validation for constraint: array
        if ('' !== ($deviceDataArrayErrorMessage = self::validateDeviceDataForArrayConstraintsFromSetDeviceData($deviceData))) {
            throw new \InvalidArgumentException($deviceDataArrayErrorMessage, __LINE__);
        }
        if (is_null($deviceData) || (is_array($deviceData) && empty($deviceData))) {
            unset($this->DeviceData);
        } else {
            $this->DeviceData = $deviceData;
        }
        return $this;
    }
    /**
     * Add item to DeviceData value
     * @throws \InvalidArgumentException
     * @param \StructType\DeviceData $item
     * @return \ArrayType\ArrayOfDeviceData
     */
    public function addToDeviceData(\StructType\DeviceData $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DeviceData) {
            throw new \InvalidArgumentException(sprintf('The DeviceData property can only contain items of type \StructType\DeviceData, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DeviceData[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\DeviceData|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\DeviceData|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\DeviceData|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\DeviceData|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\DeviceData|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string DeviceData
     */
    public function getAttributeName()
    {
        return 'DeviceData';
    }
}
