<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfBreakTime ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfBreakTime
 * @subpackage Arrays
 */
class ArrayOfBreakTime extends AbstractStructArrayBase
{
    /**
     * The BreakTime
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\BreakTime[]
     */
    public $BreakTime;
    /**
     * Constructor method for ArrayOfBreakTime
     * @uses ArrayOfBreakTime::setBreakTime()
     * @param \StructType\BreakTime[] $breakTime
     */
    public function __construct(array $breakTime = array())
    {
        $this
            ->setBreakTime($breakTime);
    }
    /**
     * Get BreakTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\BreakTime[]|null
     */
    public function getBreakTime()
    {
        return isset($this->BreakTime) ? $this->BreakTime : null;
    }
    /**
     * This method is responsible for validating the values passed to the setBreakTime method
     * This method is willingly generated in order to preserve the one-line inline validation within the setBreakTime method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateBreakTimeForArrayConstraintsFromSetBreakTime(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfBreakTimeBreakTimeItem) {
            // validation for constraint: itemType
            if (!$arrayOfBreakTimeBreakTimeItem instanceof \StructType\BreakTime) {
                $invalidValues[] = is_object($arrayOfBreakTimeBreakTimeItem) ? get_class($arrayOfBreakTimeBreakTimeItem) : sprintf('%s(%s)', gettype($arrayOfBreakTimeBreakTimeItem), var_export($arrayOfBreakTimeBreakTimeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The BreakTime property can only contain items of type \StructType\BreakTime, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set BreakTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\BreakTime[] $breakTime
     * @return \ArrayType\ArrayOfBreakTime
     */
    public function setBreakTime(array $breakTime = array())
    {
        // validation for constraint: array
        if ('' !== ($breakTimeArrayErrorMessage = self::validateBreakTimeForArrayConstraintsFromSetBreakTime($breakTime))) {
            throw new \InvalidArgumentException($breakTimeArrayErrorMessage, __LINE__);
        }
        if (is_null($breakTime) || (is_array($breakTime) && empty($breakTime))) {
            unset($this->BreakTime);
        } else {
            $this->BreakTime = $breakTime;
        }
        return $this;
    }
    /**
     * Add item to BreakTime value
     * @throws \InvalidArgumentException
     * @param \StructType\BreakTime $item
     * @return \ArrayType\ArrayOfBreakTime
     */
    public function addToBreakTime(\StructType\BreakTime $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BreakTime) {
            throw new \InvalidArgumentException(sprintf('The BreakTime property can only contain items of type \StructType\BreakTime, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->BreakTime[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\BreakTime|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\BreakTime|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\BreakTime|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\BreakTime|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\BreakTime|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string BreakTime
     */
    public function getAttributeName()
    {
        return 'BreakTime';
    }
}
