<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TAssets StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TAssets
 * @subpackage Structs
 */
class TAssets extends TAssetTypes
{
    /**
     * The assetIDField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $assetIDField;
    /**
     * The assetKeyIDField
     * @var int
     */
    public $assetKeyIDField;
    /**
     * The branchKeyIdField
     * @var int
     */
    public $branchKeyIdField;
    /**
     * The colorField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $colorField;
    /**
     * The displayOrderField
     * @var int
     */
    public $displayOrderField;
    /**
     * The showOnRouteCalendarField
     * @var bool
     */
    public $showOnRouteCalendarField;
    /**
     * The typeColorField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $typeColorField;
    /**
     * Constructor method for TAssets
     * @uses TAssets::setAssetIDField()
     * @uses TAssets::setAssetKeyIDField()
     * @uses TAssets::setBranchKeyIdField()
     * @uses TAssets::setColorField()
     * @uses TAssets::setDisplayOrderField()
     * @uses TAssets::setShowOnRouteCalendarField()
     * @uses TAssets::setTypeColorField()
     * @param string $assetIDField
     * @param int $assetKeyIDField
     * @param int $branchKeyIdField
     * @param string $colorField
     * @param int $displayOrderField
     * @param bool $showOnRouteCalendarField
     * @param string $typeColorField
     */
    public function __construct($assetIDField = null, $assetKeyIDField = null, $branchKeyIdField = null, $colorField = null, $displayOrderField = null, $showOnRouteCalendarField = null, $typeColorField = null)
    {
        $this
            ->setAssetIDField($assetIDField)
            ->setAssetKeyIDField($assetKeyIDField)
            ->setBranchKeyIdField($branchKeyIdField)
            ->setColorField($colorField)
            ->setDisplayOrderField($displayOrderField)
            ->setShowOnRouteCalendarField($showOnRouteCalendarField)
            ->setTypeColorField($typeColorField);
    }
    /**
     * Get assetIDField value
     * @return string|null
     */
    public function getAssetIDField()
    {
        return $this->assetIDField;
    }
    /**
     * Set assetIDField value
     * @param string $assetIDField
     * @return \StructType\TAssets
     */
    public function setAssetIDField($assetIDField = null)
    {
        // validation for constraint: string
        if (!is_null($assetIDField) && !is_string($assetIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assetIDField, true), gettype($assetIDField)), __LINE__);
        }
        $this->assetIDField = $assetIDField;
        return $this;
    }
    /**
     * Get assetKeyIDField value
     * @return int|null
     */
    public function getAssetKeyIDField()
    {
        return $this->assetKeyIDField;
    }
    /**
     * Set assetKeyIDField value
     * @param int $assetKeyIDField
     * @return \StructType\TAssets
     */
    public function setAssetKeyIDField($assetKeyIDField = null)
    {
        // validation for constraint: int
        if (!is_null($assetKeyIDField) && !(is_int($assetKeyIDField) || ctype_digit($assetKeyIDField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($assetKeyIDField, true), gettype($assetKeyIDField)), __LINE__);
        }
        $this->assetKeyIDField = $assetKeyIDField;
        return $this;
    }
    /**
     * Get branchKeyIdField value
     * @return int|null
     */
    public function getBranchKeyIdField()
    {
        return $this->branchKeyIdField;
    }
    /**
     * Set branchKeyIdField value
     * @param int $branchKeyIdField
     * @return \StructType\TAssets
     */
    public function setBranchKeyIdField($branchKeyIdField = null)
    {
        // validation for constraint: int
        if (!is_null($branchKeyIdField) && !(is_int($branchKeyIdField) || ctype_digit($branchKeyIdField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($branchKeyIdField, true), gettype($branchKeyIdField)), __LINE__);
        }
        $this->branchKeyIdField = $branchKeyIdField;
        return $this;
    }
    /**
     * Get colorField value
     * @return string|null
     */
    public function getColorField()
    {
        return $this->colorField;
    }
    /**
     * Set colorField value
     * @param string $colorField
     * @return \StructType\TAssets
     */
    public function setColorField($colorField = null)
    {
        // validation for constraint: string
        if (!is_null($colorField) && !is_string($colorField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($colorField, true), gettype($colorField)), __LINE__);
        }
        $this->colorField = $colorField;
        return $this;
    }
    /**
     * Get displayOrderField value
     * @return int|null
     */
    public function getDisplayOrderField()
    {
        return $this->displayOrderField;
    }
    /**
     * Set displayOrderField value
     * @param int $displayOrderField
     * @return \StructType\TAssets
     */
    public function setDisplayOrderField($displayOrderField = null)
    {
        // validation for constraint: int
        if (!is_null($displayOrderField) && !(is_int($displayOrderField) || ctype_digit($displayOrderField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($displayOrderField, true), gettype($displayOrderField)), __LINE__);
        }
        $this->displayOrderField = $displayOrderField;
        return $this;
    }
    /**
     * Get showOnRouteCalendarField value
     * @return bool|null
     */
    public function getShowOnRouteCalendarField()
    {
        return $this->showOnRouteCalendarField;
    }
    /**
     * Set showOnRouteCalendarField value
     * @param bool $showOnRouteCalendarField
     * @return \StructType\TAssets
     */
    public function setShowOnRouteCalendarField($showOnRouteCalendarField = null)
    {
        // validation for constraint: boolean
        if (!is_null($showOnRouteCalendarField) && !is_bool($showOnRouteCalendarField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showOnRouteCalendarField, true), gettype($showOnRouteCalendarField)), __LINE__);
        }
        $this->showOnRouteCalendarField = $showOnRouteCalendarField;
        return $this;
    }
    /**
     * Get typeColorField value
     * @return string|null
     */
    public function getTypeColorField()
    {
        return $this->typeColorField;
    }
    /**
     * Set typeColorField value
     * @param string $typeColorField
     * @return \StructType\TAssets
     */
    public function setTypeColorField($typeColorField = null)
    {
        // validation for constraint: string
        if (!is_null($typeColorField) && !is_string($typeColorField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeColorField, true), gettype($typeColorField)), __LINE__);
        }
        $this->typeColorField = $typeColorField;
        return $this;
    }
}
