<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RoutePlanDetailType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RoutePlanDetailType
 * @subpackage Structs
 */
class RoutePlanDetailType extends AbstractStructBase
{
    /**
     * The branchIDField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $branchIDField;
    /**
     * The delayTimeField
     * @var int
     */
    public $delayTimeField;
    /**
     * The dispatchDateField
     * @var string
     */
    public $dispatchDateField;
    /**
     * The dispatchIDField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $dispatchIDField;
    /**
     * The endTimeField
     * @var string
     */
    public $endTimeField;
    /**
     * The lastDataPostedField
     * @var string
     */
    public $lastDataPostedField;
    /**
     * The lastDateModifiedField
     * @var string
     */
    public $lastDateModifiedField;
    /**
     * The loadDateField
     * @var string
     */
    public $loadDateField;
    /**
     * The routeExportStatusField
     * @var string
     */
    public $routeExportStatusField;
    /**
     * The routeIDField
     * @var int
     */
    public $routeIDField;
    /**
     * The rtNumberField
     * @var int
     */
    public $rtNumberField;
    /**
     * The startTimeField
     * @var string
     */
    public $startTimeField;
    /**
     * The stopField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfStopPlanDetailType
     */
    public $stopField;
    /**
     * The totalDistanceCostField
     * @var float
     */
    public $totalDistanceCostField;
    /**
     * The totalDistanceField
     * @var float
     */
    public $totalDistanceField;
    /**
     * The totalDriveHrsField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $totalDriveHrsField;
    /**
     * The totalLegsField
     * @var int
     */
    public $totalLegsField;
    /**
     * The totalStopsField
     * @var int
     */
    public $totalStopsField;
    /**
     * The totalWorkHrsField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $totalWorkHrsField;
    /**
     * The violationsField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfViolationsTypeLeg
     */
    public $violationsField;
    /**
     * Constructor method for RoutePlanDetailType
     * @uses RoutePlanDetailType::setBranchIDField()
     * @uses RoutePlanDetailType::setDelayTimeField()
     * @uses RoutePlanDetailType::setDispatchDateField()
     * @uses RoutePlanDetailType::setDispatchIDField()
     * @uses RoutePlanDetailType::setEndTimeField()
     * @uses RoutePlanDetailType::setLastDataPostedField()
     * @uses RoutePlanDetailType::setLastDateModifiedField()
     * @uses RoutePlanDetailType::setLoadDateField()
     * @uses RoutePlanDetailType::setRouteExportStatusField()
     * @uses RoutePlanDetailType::setRouteIDField()
     * @uses RoutePlanDetailType::setRtNumberField()
     * @uses RoutePlanDetailType::setStartTimeField()
     * @uses RoutePlanDetailType::setStopField()
     * @uses RoutePlanDetailType::setTotalDistanceCostField()
     * @uses RoutePlanDetailType::setTotalDistanceField()
     * @uses RoutePlanDetailType::setTotalDriveHrsField()
     * @uses RoutePlanDetailType::setTotalLegsField()
     * @uses RoutePlanDetailType::setTotalStopsField()
     * @uses RoutePlanDetailType::setTotalWorkHrsField()
     * @uses RoutePlanDetailType::setViolationsField()
     * @param string $branchIDField
     * @param int $delayTimeField
     * @param string $dispatchDateField
     * @param string $dispatchIDField
     * @param string $endTimeField
     * @param string $lastDataPostedField
     * @param string $lastDateModifiedField
     * @param string $loadDateField
     * @param string $routeExportStatusField
     * @param int $routeIDField
     * @param int $rtNumberField
     * @param string $startTimeField
     * @param \ArrayType\ArrayOfStopPlanDetailType $stopField
     * @param float $totalDistanceCostField
     * @param float $totalDistanceField
     * @param string $totalDriveHrsField
     * @param int $totalLegsField
     * @param int $totalStopsField
     * @param string $totalWorkHrsField
     * @param \ArrayType\ArrayOfViolationsTypeLeg $violationsField
     */
    public function __construct($branchIDField = null, $delayTimeField = null, $dispatchDateField = null, $dispatchIDField = null, $endTimeField = null, $lastDataPostedField = null, $lastDateModifiedField = null, $loadDateField = null, $routeExportStatusField = null, $routeIDField = null, $rtNumberField = null, $startTimeField = null, \ArrayType\ArrayOfStopPlanDetailType $stopField = null, $totalDistanceCostField = null, $totalDistanceField = null, $totalDriveHrsField = null, $totalLegsField = null, $totalStopsField = null, $totalWorkHrsField = null, \ArrayType\ArrayOfViolationsTypeLeg $violationsField = null)
    {
        $this
            ->setBranchIDField($branchIDField)
            ->setDelayTimeField($delayTimeField)
            ->setDispatchDateField($dispatchDateField)
            ->setDispatchIDField($dispatchIDField)
            ->setEndTimeField($endTimeField)
            ->setLastDataPostedField($lastDataPostedField)
            ->setLastDateModifiedField($lastDateModifiedField)
            ->setLoadDateField($loadDateField)
            ->setRouteExportStatusField($routeExportStatusField)
            ->setRouteIDField($routeIDField)
            ->setRtNumberField($rtNumberField)
            ->setStartTimeField($startTimeField)
            ->setStopField($stopField)
            ->setTotalDistanceCostField($totalDistanceCostField)
            ->setTotalDistanceField($totalDistanceField)
            ->setTotalDriveHrsField($totalDriveHrsField)
            ->setTotalLegsField($totalLegsField)
            ->setTotalStopsField($totalStopsField)
            ->setTotalWorkHrsField($totalWorkHrsField)
            ->setViolationsField($violationsField);
    }
    /**
     * Get branchIDField value
     * @return string|null
     */
    public function getBranchIDField()
    {
        return $this->branchIDField;
    }
    /**
     * Set branchIDField value
     * @param string $branchIDField
     * @return \StructType\RoutePlanDetailType
     */
    public function setBranchIDField($branchIDField = null)
    {
        // validation for constraint: string
        if (!is_null($branchIDField) && !is_string($branchIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($branchIDField, true), gettype($branchIDField)), __LINE__);
        }
        $this->branchIDField = $branchIDField;
        return $this;
    }
    /**
     * Get delayTimeField value
     * @return int|null
     */
    public function getDelayTimeField()
    {
        return $this->delayTimeField;
    }
    /**
     * Set delayTimeField value
     * @param int $delayTimeField
     * @return \StructType\RoutePlanDetailType
     */
    public function setDelayTimeField($delayTimeField = null)
    {
        // validation for constraint: int
        if (!is_null($delayTimeField) && !(is_int($delayTimeField) || ctype_digit($delayTimeField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($delayTimeField, true), gettype($delayTimeField)), __LINE__);
        }
        $this->delayTimeField = $delayTimeField;
        return $this;
    }
    /**
     * Get dispatchDateField value
     * @return string|null
     */
    public function getDispatchDateField()
    {
        return $this->dispatchDateField;
    }
    /**
     * Set dispatchDateField value
     * @param string $dispatchDateField
     * @return \StructType\RoutePlanDetailType
     */
    public function setDispatchDateField($dispatchDateField = null)
    {
        // validation for constraint: string
        if (!is_null($dispatchDateField) && !is_string($dispatchDateField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dispatchDateField, true), gettype($dispatchDateField)), __LINE__);
        }
        $this->dispatchDateField = $dispatchDateField;
        return $this;
    }
    /**
     * Get dispatchIDField value
     * @return string|null
     */
    public function getDispatchIDField()
    {
        return $this->dispatchIDField;
    }
    /**
     * Set dispatchIDField value
     * @param string $dispatchIDField
     * @return \StructType\RoutePlanDetailType
     */
    public function setDispatchIDField($dispatchIDField = null)
    {
        // validation for constraint: string
        if (!is_null($dispatchIDField) && !is_string($dispatchIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dispatchIDField, true), gettype($dispatchIDField)), __LINE__);
        }
        $this->dispatchIDField = $dispatchIDField;
        return $this;
    }
    /**
     * Get endTimeField value
     * @return string|null
     */
    public function getEndTimeField()
    {
        return $this->endTimeField;
    }
    /**
     * Set endTimeField value
     * @param string $endTimeField
     * @return \StructType\RoutePlanDetailType
     */
    public function setEndTimeField($endTimeField = null)
    {
        // validation for constraint: string
        if (!is_null($endTimeField) && !is_string($endTimeField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endTimeField, true), gettype($endTimeField)), __LINE__);
        }
        $this->endTimeField = $endTimeField;
        return $this;
    }
    /**
     * Get lastDataPostedField value
     * @return string|null
     */
    public function getLastDataPostedField()
    {
        return $this->lastDataPostedField;
    }
    /**
     * Set lastDataPostedField value
     * @param string $lastDataPostedField
     * @return \StructType\RoutePlanDetailType
     */
    public function setLastDataPostedField($lastDataPostedField = null)
    {
        // validation for constraint: string
        if (!is_null($lastDataPostedField) && !is_string($lastDataPostedField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastDataPostedField, true), gettype($lastDataPostedField)), __LINE__);
        }
        $this->lastDataPostedField = $lastDataPostedField;
        return $this;
    }
    /**
     * Get lastDateModifiedField value
     * @return string|null
     */
    public function getLastDateModifiedField()
    {
        return $this->lastDateModifiedField;
    }
    /**
     * Set lastDateModifiedField value
     * @param string $lastDateModifiedField
     * @return \StructType\RoutePlanDetailType
     */
    public function setLastDateModifiedField($lastDateModifiedField = null)
    {
        // validation for constraint: string
        if (!is_null($lastDateModifiedField) && !is_string($lastDateModifiedField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastDateModifiedField, true), gettype($lastDateModifiedField)), __LINE__);
        }
        $this->lastDateModifiedField = $lastDateModifiedField;
        return $this;
    }
    /**
     * Get loadDateField value
     * @return string|null
     */
    public function getLoadDateField()
    {
        return $this->loadDateField;
    }
    /**
     * Set loadDateField value
     * @param string $loadDateField
     * @return \StructType\RoutePlanDetailType
     */
    public function setLoadDateField($loadDateField = null)
    {
        // validation for constraint: string
        if (!is_null($loadDateField) && !is_string($loadDateField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loadDateField, true), gettype($loadDateField)), __LINE__);
        }
        $this->loadDateField = $loadDateField;
        return $this;
    }
    /**
     * Get routeExportStatusField value
     * @return string|null
     */
    public function getRouteExportStatusField()
    {
        return $this->routeExportStatusField;
    }
    /**
     * Set routeExportStatusField value
     * @uses \EnumType\RouteExportStatusType::valueIsValid()
     * @uses \EnumType\RouteExportStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $routeExportStatusField
     * @return \StructType\RoutePlanDetailType
     */
    public function setRouteExportStatusField($routeExportStatusField = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RouteExportStatusType::valueIsValid($routeExportStatusField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\RouteExportStatusType', is_array($routeExportStatusField) ? implode(', ', $routeExportStatusField) : var_export($routeExportStatusField, true), implode(', ', \EnumType\RouteExportStatusType::getValidValues())), __LINE__);
        }
        $this->routeExportStatusField = $routeExportStatusField;
        return $this;
    }
    /**
     * Get routeIDField value
     * @return int|null
     */
    public function getRouteIDField()
    {
        return $this->routeIDField;
    }
    /**
     * Set routeIDField value
     * @param int $routeIDField
     * @return \StructType\RoutePlanDetailType
     */
    public function setRouteIDField($routeIDField = null)
    {
        // validation for constraint: int
        if (!is_null($routeIDField) && !(is_int($routeIDField) || ctype_digit($routeIDField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($routeIDField, true), gettype($routeIDField)), __LINE__);
        }
        $this->routeIDField = $routeIDField;
        return $this;
    }
    /**
     * Get rtNumberField value
     * @return int|null
     */
    public function getRtNumberField()
    {
        return $this->rtNumberField;
    }
    /**
     * Set rtNumberField value
     * @param int $rtNumberField
     * @return \StructType\RoutePlanDetailType
     */
    public function setRtNumberField($rtNumberField = null)
    {
        // validation for constraint: int
        if (!is_null($rtNumberField) && !(is_int($rtNumberField) || ctype_digit($rtNumberField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rtNumberField, true), gettype($rtNumberField)), __LINE__);
        }
        $this->rtNumberField = $rtNumberField;
        return $this;
    }
    /**
     * Get startTimeField value
     * @return string|null
     */
    public function getStartTimeField()
    {
        return $this->startTimeField;
    }
    /**
     * Set startTimeField value
     * @param string $startTimeField
     * @return \StructType\RoutePlanDetailType
     */
    public function setStartTimeField($startTimeField = null)
    {
        // validation for constraint: string
        if (!is_null($startTimeField) && !is_string($startTimeField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startTimeField, true), gettype($startTimeField)), __LINE__);
        }
        $this->startTimeField = $startTimeField;
        return $this;
    }
    /**
     * Get stopField value
     * @return \ArrayType\ArrayOfStopPlanDetailType|null
     */
    public function getStopField()
    {
        return $this->stopField;
    }
    /**
     * Set stopField value
     * @param \ArrayType\ArrayOfStopPlanDetailType $stopField
     * @return \StructType\RoutePlanDetailType
     */
    public function setStopField(\ArrayType\ArrayOfStopPlanDetailType $stopField = null)
    {
        $this->stopField = $stopField;
        return $this;
    }
    /**
     * Get totalDistanceCostField value
     * @return float|null
     */
    public function getTotalDistanceCostField()
    {
        return $this->totalDistanceCostField;
    }
    /**
     * Set totalDistanceCostField value
     * @param float $totalDistanceCostField
     * @return \StructType\RoutePlanDetailType
     */
    public function setTotalDistanceCostField($totalDistanceCostField = null)
    {
        // validation for constraint: float
        if (!is_null($totalDistanceCostField) && !(is_float($totalDistanceCostField) || is_numeric($totalDistanceCostField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalDistanceCostField, true), gettype($totalDistanceCostField)), __LINE__);
        }
        $this->totalDistanceCostField = $totalDistanceCostField;
        return $this;
    }
    /**
     * Get totalDistanceField value
     * @return float|null
     */
    public function getTotalDistanceField()
    {
        return $this->totalDistanceField;
    }
    /**
     * Set totalDistanceField value
     * @param float $totalDistanceField
     * @return \StructType\RoutePlanDetailType
     */
    public function setTotalDistanceField($totalDistanceField = null)
    {
        // validation for constraint: float
        if (!is_null($totalDistanceField) && !(is_float($totalDistanceField) || is_numeric($totalDistanceField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalDistanceField, true), gettype($totalDistanceField)), __LINE__);
        }
        $this->totalDistanceField = $totalDistanceField;
        return $this;
    }
    /**
     * Get totalDriveHrsField value
     * @return string|null
     */
    public function getTotalDriveHrsField()
    {
        return $this->totalDriveHrsField;
    }
    /**
     * Set totalDriveHrsField value
     * @param string $totalDriveHrsField
     * @return \StructType\RoutePlanDetailType
     */
    public function setTotalDriveHrsField($totalDriveHrsField = null)
    {
        // validation for constraint: string
        if (!is_null($totalDriveHrsField) && !is_string($totalDriveHrsField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalDriveHrsField, true), gettype($totalDriveHrsField)), __LINE__);
        }
        $this->totalDriveHrsField = $totalDriveHrsField;
        return $this;
    }
    /**
     * Get totalLegsField value
     * @return int|null
     */
    public function getTotalLegsField()
    {
        return $this->totalLegsField;
    }
    /**
     * Set totalLegsField value
     * @param int $totalLegsField
     * @return \StructType\RoutePlanDetailType
     */
    public function setTotalLegsField($totalLegsField = null)
    {
        // validation for constraint: int
        if (!is_null($totalLegsField) && !(is_int($totalLegsField) || ctype_digit($totalLegsField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalLegsField, true), gettype($totalLegsField)), __LINE__);
        }
        $this->totalLegsField = $totalLegsField;
        return $this;
    }
    /**
     * Get totalStopsField value
     * @return int|null
     */
    public function getTotalStopsField()
    {
        return $this->totalStopsField;
    }
    /**
     * Set totalStopsField value
     * @param int $totalStopsField
     * @return \StructType\RoutePlanDetailType
     */
    public function setTotalStopsField($totalStopsField = null)
    {
        // validation for constraint: int
        if (!is_null($totalStopsField) && !(is_int($totalStopsField) || ctype_digit($totalStopsField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalStopsField, true), gettype($totalStopsField)), __LINE__);
        }
        $this->totalStopsField = $totalStopsField;
        return $this;
    }
    /**
     * Get totalWorkHrsField value
     * @return string|null
     */
    public function getTotalWorkHrsField()
    {
        return $this->totalWorkHrsField;
    }
    /**
     * Set totalWorkHrsField value
     * @param string $totalWorkHrsField
     * @return \StructType\RoutePlanDetailType
     */
    public function setTotalWorkHrsField($totalWorkHrsField = null)
    {
        // validation for constraint: string
        if (!is_null($totalWorkHrsField) && !is_string($totalWorkHrsField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($totalWorkHrsField, true), gettype($totalWorkHrsField)), __LINE__);
        }
        $this->totalWorkHrsField = $totalWorkHrsField;
        return $this;
    }
    /**
     * Get violationsField value
     * @return \ArrayType\ArrayOfViolationsTypeLeg|null
     */
    public function getViolationsField()
    {
        return $this->violationsField;
    }
    /**
     * Set violationsField value
     * @param \ArrayType\ArrayOfViolationsTypeLeg $violationsField
     * @return \StructType\RoutePlanDetailType
     */
    public function setViolationsField(\ArrayType\ArrayOfViolationsTypeLeg $violationsField = null)
    {
        $this->violationsField = $violationsField;
        return $this;
    }
}
