<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RouteDetailReturnOptions StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RouteDetailReturnOptions
 * @subpackage Structs
 */
class RouteDetailReturnOptions extends AbstractStructBase
{
    /**
     * The filtersField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\RouteDetailReturnOptionsFilters
     */
    public $filtersField;
    /**
     * The statusTypeField
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $statusTypeField;
    /**
     * Constructor method for RouteDetailReturnOptions
     * @uses RouteDetailReturnOptions::setFiltersField()
     * @uses RouteDetailReturnOptions::setStatusTypeField()
     * @param \StructType\RouteDetailReturnOptionsFilters $filtersField
     * @param string $statusTypeField
     */
    public function __construct(\StructType\RouteDetailReturnOptionsFilters $filtersField = null, $statusTypeField = null)
    {
        $this
            ->setFiltersField($filtersField)
            ->setStatusTypeField($statusTypeField);
    }
    /**
     * Get filtersField value
     * @return \StructType\RouteDetailReturnOptionsFilters|null
     */
    public function getFiltersField()
    {
        return $this->filtersField;
    }
    /**
     * Set filtersField value
     * @param \StructType\RouteDetailReturnOptionsFilters $filtersField
     * @return \StructType\RouteDetailReturnOptions
     */
    public function setFiltersField(\StructType\RouteDetailReturnOptionsFilters $filtersField = null)
    {
        $this->filtersField = $filtersField;
        return $this;
    }
    /**
     * Get statusTypeField value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusTypeField()
    {
        return isset($this->statusTypeField) ? $this->statusTypeField : null;
    }
    /**
     * Set statusTypeField value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statusTypeField
     * @return \StructType\RouteDetailReturnOptions
     */
    public function setStatusTypeField($statusTypeField = null)
    {
        // validation for constraint: string
        if (!is_null($statusTypeField) && !is_string($statusTypeField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusTypeField, true), gettype($statusTypeField)), __LINE__);
        }
        if (is_null($statusTypeField) || (is_array($statusTypeField) && empty($statusTypeField))) {
            unset($this->statusTypeField);
        } else {
            $this->statusTypeField = $statusTypeField;
        }
        return $this;
    }
}
