<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for RouteCandidates StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:RouteCandidates
 * @subpackage Structs
 */
class RouteCandidates extends AbstractStructBase
{
    /**
     * The estimatedArrivalField
     * @var string
     */
    public $estimatedArrivalField;
    /**
     * The incrCostField
     * @var float
     */
    public $incrCostField;
    /**
     * The incrMilesField
     * @var float
     */
    public $incrMilesField;
    /**
     * The keyField
     * @var int
     */
    public $keyField;
    /**
     * The legField
     * @var int
     */
    public $legField;
    /**
     * The loadIDField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $loadIDField;
    /**
     * The nViolationsField
     * @var int
     */
    public $nViolationsField;
    /**
     * The rTIDField
     * @var int
     */
    public $rTIDField;
    /**
     * The rtField
     * @var int
     */
    public $rtField;
    /**
     * The seqField
     * @var int
     */
    public $seqField;
    /**
     * The totalStopsField
     * @var int
     */
    public $totalStopsField;
    /**
     * The truckKeyField
     * @var int
     */
    public $truckKeyField;
    /**
     * The violationStringField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $violationStringField;
    /**
     * Constructor method for RouteCandidates
     * @uses RouteCandidates::setEstimatedArrivalField()
     * @uses RouteCandidates::setIncrCostField()
     * @uses RouteCandidates::setIncrMilesField()
     * @uses RouteCandidates::setKeyField()
     * @uses RouteCandidates::setLegField()
     * @uses RouteCandidates::setLoadIDField()
     * @uses RouteCandidates::setNViolationsField()
     * @uses RouteCandidates::setRTIDField()
     * @uses RouteCandidates::setRtField()
     * @uses RouteCandidates::setSeqField()
     * @uses RouteCandidates::setTotalStopsField()
     * @uses RouteCandidates::setTruckKeyField()
     * @uses RouteCandidates::setViolationStringField()
     * @param string $estimatedArrivalField
     * @param float $incrCostField
     * @param float $incrMilesField
     * @param int $keyField
     * @param int $legField
     * @param string $loadIDField
     * @param int $nViolationsField
     * @param int $rTIDField
     * @param int $rtField
     * @param int $seqField
     * @param int $totalStopsField
     * @param int $truckKeyField
     * @param string $violationStringField
     */
    public function __construct($estimatedArrivalField = null, $incrCostField = null, $incrMilesField = null, $keyField = null, $legField = null, $loadIDField = null, $nViolationsField = null, $rTIDField = null, $rtField = null, $seqField = null, $totalStopsField = null, $truckKeyField = null, $violationStringField = null)
    {
        $this
            ->setEstimatedArrivalField($estimatedArrivalField)
            ->setIncrCostField($incrCostField)
            ->setIncrMilesField($incrMilesField)
            ->setKeyField($keyField)
            ->setLegField($legField)
            ->setLoadIDField($loadIDField)
            ->setNViolationsField($nViolationsField)
            ->setRTIDField($rTIDField)
            ->setRtField($rtField)
            ->setSeqField($seqField)
            ->setTotalStopsField($totalStopsField)
            ->setTruckKeyField($truckKeyField)
            ->setViolationStringField($violationStringField);
    }
    /**
     * Get estimatedArrivalField value
     * @return string|null
     */
    public function getEstimatedArrivalField()
    {
        return $this->estimatedArrivalField;
    }
    /**
     * Set estimatedArrivalField value
     * @param string $estimatedArrivalField
     * @return \StructType\RouteCandidates
     */
    public function setEstimatedArrivalField($estimatedArrivalField = null)
    {
        // validation for constraint: string
        if (!is_null($estimatedArrivalField) && !is_string($estimatedArrivalField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($estimatedArrivalField, true), gettype($estimatedArrivalField)), __LINE__);
        }
        $this->estimatedArrivalField = $estimatedArrivalField;
        return $this;
    }
    /**
     * Get incrCostField value
     * @return float|null
     */
    public function getIncrCostField()
    {
        return $this->incrCostField;
    }
    /**
     * Set incrCostField value
     * @param float $incrCostField
     * @return \StructType\RouteCandidates
     */
    public function setIncrCostField($incrCostField = null)
    {
        // validation for constraint: float
        if (!is_null($incrCostField) && !(is_float($incrCostField) || is_numeric($incrCostField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($incrCostField, true), gettype($incrCostField)), __LINE__);
        }
        $this->incrCostField = $incrCostField;
        return $this;
    }
    /**
     * Get incrMilesField value
     * @return float|null
     */
    public function getIncrMilesField()
    {
        return $this->incrMilesField;
    }
    /**
     * Set incrMilesField value
     * @param float $incrMilesField
     * @return \StructType\RouteCandidates
     */
    public function setIncrMilesField($incrMilesField = null)
    {
        // validation for constraint: float
        if (!is_null($incrMilesField) && !(is_float($incrMilesField) || is_numeric($incrMilesField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($incrMilesField, true), gettype($incrMilesField)), __LINE__);
        }
        $this->incrMilesField = $incrMilesField;
        return $this;
    }
    /**
     * Get keyField value
     * @return int|null
     */
    public function getKeyField()
    {
        return $this->keyField;
    }
    /**
     * Set keyField value
     * @param int $keyField
     * @return \StructType\RouteCandidates
     */
    public function setKeyField($keyField = null)
    {
        // validation for constraint: int
        if (!is_null($keyField) && !(is_int($keyField) || ctype_digit($keyField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($keyField, true), gettype($keyField)), __LINE__);
        }
        $this->keyField = $keyField;
        return $this;
    }
    /**
     * Get legField value
     * @return int|null
     */
    public function getLegField()
    {
        return $this->legField;
    }
    /**
     * Set legField value
     * @param int $legField
     * @return \StructType\RouteCandidates
     */
    public function setLegField($legField = null)
    {
        // validation for constraint: int
        if (!is_null($legField) && !(is_int($legField) || ctype_digit($legField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($legField, true), gettype($legField)), __LINE__);
        }
        $this->legField = $legField;
        return $this;
    }
    /**
     * Get loadIDField value
     * @return string|null
     */
    public function getLoadIDField()
    {
        return $this->loadIDField;
    }
    /**
     * Set loadIDField value
     * @param string $loadIDField
     * @return \StructType\RouteCandidates
     */
    public function setLoadIDField($loadIDField = null)
    {
        // validation for constraint: string
        if (!is_null($loadIDField) && !is_string($loadIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loadIDField, true), gettype($loadIDField)), __LINE__);
        }
        $this->loadIDField = $loadIDField;
        return $this;
    }
    /**
     * Get nViolationsField value
     * @return int|null
     */
    public function getNViolationsField()
    {
        return $this->nViolationsField;
    }
    /**
     * Set nViolationsField value
     * @param int $nViolationsField
     * @return \StructType\RouteCandidates
     */
    public function setNViolationsField($nViolationsField = null)
    {
        // validation for constraint: int
        if (!is_null($nViolationsField) && !(is_int($nViolationsField) || ctype_digit($nViolationsField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nViolationsField, true), gettype($nViolationsField)), __LINE__);
        }
        $this->nViolationsField = $nViolationsField;
        return $this;
    }
    /**
     * Get rTIDField value
     * @return int|null
     */
    public function getRTIDField()
    {
        return $this->rTIDField;
    }
    /**
     * Set rTIDField value
     * @param int $rTIDField
     * @return \StructType\RouteCandidates
     */
    public function setRTIDField($rTIDField = null)
    {
        // validation for constraint: int
        if (!is_null($rTIDField) && !(is_int($rTIDField) || ctype_digit($rTIDField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rTIDField, true), gettype($rTIDField)), __LINE__);
        }
        $this->rTIDField = $rTIDField;
        return $this;
    }
    /**
     * Get rtField value
     * @return int|null
     */
    public function getRtField()
    {
        return $this->rtField;
    }
    /**
     * Set rtField value
     * @param int $rtField
     * @return \StructType\RouteCandidates
     */
    public function setRtField($rtField = null)
    {
        // validation for constraint: int
        if (!is_null($rtField) && !(is_int($rtField) || ctype_digit($rtField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rtField, true), gettype($rtField)), __LINE__);
        }
        $this->rtField = $rtField;
        return $this;
    }
    /**
     * Get seqField value
     * @return int|null
     */
    public function getSeqField()
    {
        return $this->seqField;
    }
    /**
     * Set seqField value
     * @param int $seqField
     * @return \StructType\RouteCandidates
     */
    public function setSeqField($seqField = null)
    {
        // validation for constraint: int
        if (!is_null($seqField) && !(is_int($seqField) || ctype_digit($seqField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seqField, true), gettype($seqField)), __LINE__);
        }
        $this->seqField = $seqField;
        return $this;
    }
    /**
     * Get totalStopsField value
     * @return int|null
     */
    public function getTotalStopsField()
    {
        return $this->totalStopsField;
    }
    /**
     * Set totalStopsField value
     * @param int $totalStopsField
     * @return \StructType\RouteCandidates
     */
    public function setTotalStopsField($totalStopsField = null)
    {
        // validation for constraint: int
        if (!is_null($totalStopsField) && !(is_int($totalStopsField) || ctype_digit($totalStopsField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalStopsField, true), gettype($totalStopsField)), __LINE__);
        }
        $this->totalStopsField = $totalStopsField;
        return $this;
    }
    /**
     * Get truckKeyField value
     * @return int|null
     */
    public function getTruckKeyField()
    {
        return $this->truckKeyField;
    }
    /**
     * Set truckKeyField value
     * @param int $truckKeyField
     * @return \StructType\RouteCandidates
     */
    public function setTruckKeyField($truckKeyField = null)
    {
        // validation for constraint: int
        if (!is_null($truckKeyField) && !(is_int($truckKeyField) || ctype_digit($truckKeyField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($truckKeyField, true), gettype($truckKeyField)), __LINE__);
        }
        $this->truckKeyField = $truckKeyField;
        return $this;
    }
    /**
     * Get violationStringField value
     * @return string|null
     */
    public function getViolationStringField()
    {
        return $this->violationStringField;
    }
    /**
     * Set violationStringField value
     * @param string $violationStringField
     * @return \StructType\RouteCandidates
     */
    public function setViolationStringField($violationStringField = null)
    {
        // validation for constraint: string
        if (!is_null($violationStringField) && !is_string($violationStringField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($violationStringField, true), gettype($violationStringField)), __LINE__);
        }
        $this->violationStringField = $violationStringField;
        return $this;
    }
}
