<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderDetailReturnOptionsFilters StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OrderDetailReturnOptionsFilters
 * @subpackage Structs
 */
class OrderDetailReturnOptionsFilters extends AbstractStructBase
{
    /**
     * The accountIDListField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $accountIDListField;
    /**
     * The formListField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $formListField;
    /**
     * The orderIDListField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $orderIDListField;
    /**
     * The orderTypeField
     * @var string
     */
    public $orderTypeField;
    /**
     * The quantityFieldListField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $quantityFieldListField;
    /**
     * The userFieldListField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $userFieldListField;
    /**
     * Constructor method for OrderDetailReturnOptionsFilters
     * @uses OrderDetailReturnOptionsFilters::setAccountIDListField()
     * @uses OrderDetailReturnOptionsFilters::setFormListField()
     * @uses OrderDetailReturnOptionsFilters::setOrderIDListField()
     * @uses OrderDetailReturnOptionsFilters::setOrderTypeField()
     * @uses OrderDetailReturnOptionsFilters::setQuantityFieldListField()
     * @uses OrderDetailReturnOptionsFilters::setUserFieldListField()
     * @param \ArrayType\ArrayOfstring $accountIDListField
     * @param \ArrayType\ArrayOfstring $formListField
     * @param \ArrayType\ArrayOfstring $orderIDListField
     * @param string $orderTypeField
     * @param \ArrayType\ArrayOfstring $quantityFieldListField
     * @param \ArrayType\ArrayOfstring $userFieldListField
     */
    public function __construct(\ArrayType\ArrayOfstring $accountIDListField = null, \ArrayType\ArrayOfstring $formListField = null, \ArrayType\ArrayOfstring $orderIDListField = null, $orderTypeField = null, \ArrayType\ArrayOfstring $quantityFieldListField = null, \ArrayType\ArrayOfstring $userFieldListField = null)
    {
        $this
            ->setAccountIDListField($accountIDListField)
            ->setFormListField($formListField)
            ->setOrderIDListField($orderIDListField)
            ->setOrderTypeField($orderTypeField)
            ->setQuantityFieldListField($quantityFieldListField)
            ->setUserFieldListField($userFieldListField);
    }
    /**
     * Get accountIDListField value
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getAccountIDListField()
    {
        return $this->accountIDListField;
    }
    /**
     * Set accountIDListField value
     * @param \ArrayType\ArrayOfstring $accountIDListField
     * @return \StructType\OrderDetailReturnOptionsFilters
     */
    public function setAccountIDListField(\ArrayType\ArrayOfstring $accountIDListField = null)
    {
        $this->accountIDListField = $accountIDListField;
        return $this;
    }
    /**
     * Get formListField value
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getFormListField()
    {
        return $this->formListField;
    }
    /**
     * Set formListField value
     * @param \ArrayType\ArrayOfstring $formListField
     * @return \StructType\OrderDetailReturnOptionsFilters
     */
    public function setFormListField(\ArrayType\ArrayOfstring $formListField = null)
    {
        $this->formListField = $formListField;
        return $this;
    }
    /**
     * Get orderIDListField value
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getOrderIDListField()
    {
        return $this->orderIDListField;
    }
    /**
     * Set orderIDListField value
     * @param \ArrayType\ArrayOfstring $orderIDListField
     * @return \StructType\OrderDetailReturnOptionsFilters
     */
    public function setOrderIDListField(\ArrayType\ArrayOfstring $orderIDListField = null)
    {
        $this->orderIDListField = $orderIDListField;
        return $this;
    }
    /**
     * Get orderTypeField value
     * @return string|null
     */
    public function getOrderTypeField()
    {
        return $this->orderTypeField;
    }
    /**
     * Set orderTypeField value
     * @uses \EnumType\OrderType::valueIsValid()
     * @uses \EnumType\OrderType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderTypeField
     * @return \StructType\OrderDetailReturnOptionsFilters
     */
    public function setOrderTypeField($orderTypeField = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OrderType::valueIsValid($orderTypeField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OrderType', is_array($orderTypeField) ? implode(', ', $orderTypeField) : var_export($orderTypeField, true), implode(', ', \EnumType\OrderType::getValidValues())), __LINE__);
        }
        $this->orderTypeField = $orderTypeField;
        return $this;
    }
    /**
     * Get quantityFieldListField value
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getQuantityFieldListField()
    {
        return $this->quantityFieldListField;
    }
    /**
     * Set quantityFieldListField value
     * @param \ArrayType\ArrayOfstring $quantityFieldListField
     * @return \StructType\OrderDetailReturnOptionsFilters
     */
    public function setQuantityFieldListField(\ArrayType\ArrayOfstring $quantityFieldListField = null)
    {
        $this->quantityFieldListField = $quantityFieldListField;
        return $this;
    }
    /**
     * Get userFieldListField value
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getUserFieldListField()
    {
        return $this->userFieldListField;
    }
    /**
     * Set userFieldListField value
     * @param \ArrayType\ArrayOfstring $userFieldListField
     * @return \StructType\OrderDetailReturnOptionsFilters
     */
    public function setUserFieldListField(\ArrayType\ArrayOfstring $userFieldListField = null)
    {
        $this->userFieldListField = $userFieldListField;
        return $this;
    }
}
