<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OrderDetailPlanDetailType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:OrderDetailPlanDetailType
 * @subpackage Structs
 */
class OrderDetailPlanDetailType extends AbstractStructBase
{
    /**
     * The accountIDField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $accountIDField;
    /**
     * The accountKeyIDField
     * @var int
     */
    public $accountKeyIDField;
    /**
     * The eqCodeField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $eqCodeField;
    /**
     * The lineItemField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfLineItemDetailPlanType
     */
    public $lineItemField;
    /**
     * The orderIDField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $orderIDField;
    /**
     * The orderKeyIDField
     * @var int
     */
    public $orderKeyIDField;
    /**
     * The orderStatusField
     * @var string
     */
    public $orderStatusField;
    /**
     * The shipToKeyIDField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var int
     */
    public $shipToKeyIDField;
    /**
     * Constructor method for OrderDetailPlanDetailType
     * @uses OrderDetailPlanDetailType::setAccountIDField()
     * @uses OrderDetailPlanDetailType::setAccountKeyIDField()
     * @uses OrderDetailPlanDetailType::setEqCodeField()
     * @uses OrderDetailPlanDetailType::setLineItemField()
     * @uses OrderDetailPlanDetailType::setOrderIDField()
     * @uses OrderDetailPlanDetailType::setOrderKeyIDField()
     * @uses OrderDetailPlanDetailType::setOrderStatusField()
     * @uses OrderDetailPlanDetailType::setShipToKeyIDField()
     * @param string $accountIDField
     * @param int $accountKeyIDField
     * @param string $eqCodeField
     * @param \ArrayType\ArrayOfLineItemDetailPlanType $lineItemField
     * @param string $orderIDField
     * @param int $orderKeyIDField
     * @param string $orderStatusField
     * @param int $shipToKeyIDField
     */
    public function __construct($accountIDField = null, $accountKeyIDField = null, $eqCodeField = null, \ArrayType\ArrayOfLineItemDetailPlanType $lineItemField = null, $orderIDField = null, $orderKeyIDField = null, $orderStatusField = null, $shipToKeyIDField = null)
    {
        $this
            ->setAccountIDField($accountIDField)
            ->setAccountKeyIDField($accountKeyIDField)
            ->setEqCodeField($eqCodeField)
            ->setLineItemField($lineItemField)
            ->setOrderIDField($orderIDField)
            ->setOrderKeyIDField($orderKeyIDField)
            ->setOrderStatusField($orderStatusField)
            ->setShipToKeyIDField($shipToKeyIDField);
    }
    /**
     * Get accountIDField value
     * @return string|null
     */
    public function getAccountIDField()
    {
        return $this->accountIDField;
    }
    /**
     * Set accountIDField value
     * @param string $accountIDField
     * @return \StructType\OrderDetailPlanDetailType
     */
    public function setAccountIDField($accountIDField = null)
    {
        // validation for constraint: string
        if (!is_null($accountIDField) && !is_string($accountIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountIDField, true), gettype($accountIDField)), __LINE__);
        }
        $this->accountIDField = $accountIDField;
        return $this;
    }
    /**
     * Get accountKeyIDField value
     * @return int|null
     */
    public function getAccountKeyIDField()
    {
        return $this->accountKeyIDField;
    }
    /**
     * Set accountKeyIDField value
     * @param int $accountKeyIDField
     * @return \StructType\OrderDetailPlanDetailType
     */
    public function setAccountKeyIDField($accountKeyIDField = null)
    {
        // validation for constraint: int
        if (!is_null($accountKeyIDField) && !(is_int($accountKeyIDField) || ctype_digit($accountKeyIDField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($accountKeyIDField, true), gettype($accountKeyIDField)), __LINE__);
        }
        $this->accountKeyIDField = $accountKeyIDField;
        return $this;
    }
    /**
     * Get eqCodeField value
     * @return string|null
     */
    public function getEqCodeField()
    {
        return $this->eqCodeField;
    }
    /**
     * Set eqCodeField value
     * @param string $eqCodeField
     * @return \StructType\OrderDetailPlanDetailType
     */
    public function setEqCodeField($eqCodeField = null)
    {
        // validation for constraint: string
        if (!is_null($eqCodeField) && !is_string($eqCodeField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eqCodeField, true), gettype($eqCodeField)), __LINE__);
        }
        $this->eqCodeField = $eqCodeField;
        return $this;
    }
    /**
     * Get lineItemField value
     * @return \ArrayType\ArrayOfLineItemDetailPlanType|null
     */
    public function getLineItemField()
    {
        return $this->lineItemField;
    }
    /**
     * Set lineItemField value
     * @param \ArrayType\ArrayOfLineItemDetailPlanType $lineItemField
     * @return \StructType\OrderDetailPlanDetailType
     */
    public function setLineItemField(\ArrayType\ArrayOfLineItemDetailPlanType $lineItemField = null)
    {
        $this->lineItemField = $lineItemField;
        return $this;
    }
    /**
     * Get orderIDField value
     * @return string|null
     */
    public function getOrderIDField()
    {
        return $this->orderIDField;
    }
    /**
     * Set orderIDField value
     * @param string $orderIDField
     * @return \StructType\OrderDetailPlanDetailType
     */
    public function setOrderIDField($orderIDField = null)
    {
        // validation for constraint: string
        if (!is_null($orderIDField) && !is_string($orderIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderIDField, true), gettype($orderIDField)), __LINE__);
        }
        $this->orderIDField = $orderIDField;
        return $this;
    }
    /**
     * Get orderKeyIDField value
     * @return int|null
     */
    public function getOrderKeyIDField()
    {
        return $this->orderKeyIDField;
    }
    /**
     * Set orderKeyIDField value
     * @param int $orderKeyIDField
     * @return \StructType\OrderDetailPlanDetailType
     */
    public function setOrderKeyIDField($orderKeyIDField = null)
    {
        // validation for constraint: int
        if (!is_null($orderKeyIDField) && !(is_int($orderKeyIDField) || ctype_digit($orderKeyIDField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderKeyIDField, true), gettype($orderKeyIDField)), __LINE__);
        }
        $this->orderKeyIDField = $orderKeyIDField;
        return $this;
    }
    /**
     * Get orderStatusField value
     * @return string|null
     */
    public function getOrderStatusField()
    {
        return $this->orderStatusField;
    }
    /**
     * Set orderStatusField value
     * @uses \EnumType\OrderStatusType::valueIsValid()
     * @uses \EnumType\OrderStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $orderStatusField
     * @return \StructType\OrderDetailPlanDetailType
     */
    public function setOrderStatusField($orderStatusField = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OrderStatusType::valueIsValid($orderStatusField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OrderStatusType', is_array($orderStatusField) ? implode(', ', $orderStatusField) : var_export($orderStatusField, true), implode(', ', \EnumType\OrderStatusType::getValidValues())), __LINE__);
        }
        $this->orderStatusField = $orderStatusField;
        return $this;
    }
    /**
     * Get shipToKeyIDField value
     * @return int|null
     */
    public function getShipToKeyIDField()
    {
        return $this->shipToKeyIDField;
    }
    /**
     * Set shipToKeyIDField value
     * @param int $shipToKeyIDField
     * @return \StructType\OrderDetailPlanDetailType
     */
    public function setShipToKeyIDField($shipToKeyIDField = null)
    {
        // validation for constraint: int
        if (!is_null($shipToKeyIDField) && !(is_int($shipToKeyIDField) || ctype_digit($shipToKeyIDField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shipToKeyIDField, true), gettype($shipToKeyIDField)), __LINE__);
        }
        $this->shipToKeyIDField = $shipToKeyIDField;
        return $this;
    }
}
