<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MaxRouteByBranchResponseEnvelope StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:MaxRouteByBranchResponseEnvelope
 * @subpackage Structs
 */
class MaxRouteByBranchResponseEnvelope extends AbstractStructBase
{
    /**
     * The responseStatusField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\ResponseStatus
     */
    public $responseStatusField;
    /**
     * The routeNumberField
     * @var int
     */
    public $routeNumberField;
    /**
     * Constructor method for MaxRouteByBranchResponseEnvelope
     * @uses MaxRouteByBranchResponseEnvelope::setResponseStatusField()
     * @uses MaxRouteByBranchResponseEnvelope::setRouteNumberField()
     * @param \StructType\ResponseStatus $responseStatusField
     * @param int $routeNumberField
     */
    public function __construct(\StructType\ResponseStatus $responseStatusField = null, $routeNumberField = null)
    {
        $this
            ->setResponseStatusField($responseStatusField)
            ->setRouteNumberField($routeNumberField);
    }
    /**
     * Get responseStatusField value
     * @return \StructType\ResponseStatus|null
     */
    public function getResponseStatusField()
    {
        return $this->responseStatusField;
    }
    /**
     * Set responseStatusField value
     * @param \StructType\ResponseStatus $responseStatusField
     * @return \StructType\MaxRouteByBranchResponseEnvelope
     */
    public function setResponseStatusField(\StructType\ResponseStatus $responseStatusField = null)
    {
        $this->responseStatusField = $responseStatusField;
        return $this;
    }
    /**
     * Get routeNumberField value
     * @return int|null
     */
    public function getRouteNumberField()
    {
        return $this->routeNumberField;
    }
    /**
     * Set routeNumberField value
     * @param int $routeNumberField
     * @return \StructType\MaxRouteByBranchResponseEnvelope
     */
    public function setRouteNumberField($routeNumberField = null)
    {
        // validation for constraint: int
        if (!is_null($routeNumberField) && !(is_int($routeNumberField) || ctype_digit($routeNumberField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($routeNumberField, true), gettype($routeNumberField)), __LINE__);
        }
        $this->routeNumberField = $routeNumberField;
        return $this;
    }
}
