<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LineItemType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:LineItemType
 * @subpackage Structs
 */
class LineItemType extends AbstractStructBase
{
    /**
     * The actualField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\LineItemActualType
     */
    public $actualField;
    /**
     * The lineItemIDField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $lineItemIDField;
    /**
     * The lineItemKeyIDField
     * @var int
     */
    public $lineItemKeyIDField;
    /**
     * The planField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\LineItemPlanType
     */
    public $planField;
    /**
     * Constructor method for LineItemType
     * @uses LineItemType::setActualField()
     * @uses LineItemType::setLineItemIDField()
     * @uses LineItemType::setLineItemKeyIDField()
     * @uses LineItemType::setPlanField()
     * @param \StructType\LineItemActualType $actualField
     * @param string $lineItemIDField
     * @param int $lineItemKeyIDField
     * @param \StructType\LineItemPlanType $planField
     */
    public function __construct(\StructType\LineItemActualType $actualField = null, $lineItemIDField = null, $lineItemKeyIDField = null, \StructType\LineItemPlanType $planField = null)
    {
        $this
            ->setActualField($actualField)
            ->setLineItemIDField($lineItemIDField)
            ->setLineItemKeyIDField($lineItemKeyIDField)
            ->setPlanField($planField);
    }
    /**
     * Get actualField value
     * @return \StructType\LineItemActualType|null
     */
    public function getActualField()
    {
        return $this->actualField;
    }
    /**
     * Set actualField value
     * @param \StructType\LineItemActualType $actualField
     * @return \StructType\LineItemType
     */
    public function setActualField(\StructType\LineItemActualType $actualField = null)
    {
        $this->actualField = $actualField;
        return $this;
    }
    /**
     * Get lineItemIDField value
     * @return string|null
     */
    public function getLineItemIDField()
    {
        return $this->lineItemIDField;
    }
    /**
     * Set lineItemIDField value
     * @param string $lineItemIDField
     * @return \StructType\LineItemType
     */
    public function setLineItemIDField($lineItemIDField = null)
    {
        // validation for constraint: string
        if (!is_null($lineItemIDField) && !is_string($lineItemIDField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lineItemIDField, true), gettype($lineItemIDField)), __LINE__);
        }
        $this->lineItemIDField = $lineItemIDField;
        return $this;
    }
    /**
     * Get lineItemKeyIDField value
     * @return int|null
     */
    public function getLineItemKeyIDField()
    {
        return $this->lineItemKeyIDField;
    }
    /**
     * Set lineItemKeyIDField value
     * @param int $lineItemKeyIDField
     * @return \StructType\LineItemType
     */
    public function setLineItemKeyIDField($lineItemKeyIDField = null)
    {
        // validation for constraint: int
        if (!is_null($lineItemKeyIDField) && !(is_int($lineItemKeyIDField) || ctype_digit($lineItemKeyIDField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lineItemKeyIDField, true), gettype($lineItemKeyIDField)), __LINE__);
        }
        $this->lineItemKeyIDField = $lineItemKeyIDField;
        return $this;
    }
    /**
     * Get planField value
     * @return \StructType\LineItemPlanType|null
     */
    public function getPlanField()
    {
        return $this->planField;
    }
    /**
     * Set planField value
     * @param \StructType\LineItemPlanType $planField
     * @return \StructType\LineItemType
     */
    public function setPlanField(\StructType\LineItemPlanType $planField = null)
    {
        $this->planField = $planField;
        return $this;
    }
}
