<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GPSPointDetailType StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GPSPointDetailType
 * @subpackage Structs
 */
class GPSPointDetailType extends AbstractStructBase
{
    /**
     * The coordinatesField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \StructType\Coordinates
     */
    public $coordinatesField;
    /**
     * The gPSTimeField
     * @var string
     */
    public $gPSTimeField;
    /**
     * The headingField
     * @var int
     */
    public $headingField;
    /**
     * The odometerField
     * @var float
     */
    public $odometerField;
    /**
     * The satellitesField
     * @var int
     */
    public $satellitesField;
    /**
     * The speedField
     * @var int
     */
    public $speedField;
    /**
     * Constructor method for GPSPointDetailType
     * @uses GPSPointDetailType::setCoordinatesField()
     * @uses GPSPointDetailType::setGPSTimeField()
     * @uses GPSPointDetailType::setHeadingField()
     * @uses GPSPointDetailType::setOdometerField()
     * @uses GPSPointDetailType::setSatellitesField()
     * @uses GPSPointDetailType::setSpeedField()
     * @param \StructType\Coordinates $coordinatesField
     * @param string $gPSTimeField
     * @param int $headingField
     * @param float $odometerField
     * @param int $satellitesField
     * @param int $speedField
     */
    public function __construct(\StructType\Coordinates $coordinatesField = null, $gPSTimeField = null, $headingField = null, $odometerField = null, $satellitesField = null, $speedField = null)
    {
        $this
            ->setCoordinatesField($coordinatesField)
            ->setGPSTimeField($gPSTimeField)
            ->setHeadingField($headingField)
            ->setOdometerField($odometerField)
            ->setSatellitesField($satellitesField)
            ->setSpeedField($speedField);
    }
    /**
     * Get coordinatesField value
     * @return \StructType\Coordinates|null
     */
    public function getCoordinatesField()
    {
        return $this->coordinatesField;
    }
    /**
     * Set coordinatesField value
     * @param \StructType\Coordinates $coordinatesField
     * @return \StructType\GPSPointDetailType
     */
    public function setCoordinatesField(\StructType\Coordinates $coordinatesField = null)
    {
        $this->coordinatesField = $coordinatesField;
        return $this;
    }
    /**
     * Get gPSTimeField value
     * @return string|null
     */
    public function getGPSTimeField()
    {
        return $this->gPSTimeField;
    }
    /**
     * Set gPSTimeField value
     * @param string $gPSTimeField
     * @return \StructType\GPSPointDetailType
     */
    public function setGPSTimeField($gPSTimeField = null)
    {
        // validation for constraint: string
        if (!is_null($gPSTimeField) && !is_string($gPSTimeField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gPSTimeField, true), gettype($gPSTimeField)), __LINE__);
        }
        $this->gPSTimeField = $gPSTimeField;
        return $this;
    }
    /**
     * Get headingField value
     * @return int|null
     */
    public function getHeadingField()
    {
        return $this->headingField;
    }
    /**
     * Set headingField value
     * @param int $headingField
     * @return \StructType\GPSPointDetailType
     */
    public function setHeadingField($headingField = null)
    {
        // validation for constraint: int
        if (!is_null($headingField) && !(is_int($headingField) || ctype_digit($headingField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($headingField, true), gettype($headingField)), __LINE__);
        }
        $this->headingField = $headingField;
        return $this;
    }
    /**
     * Get odometerField value
     * @return float|null
     */
    public function getOdometerField()
    {
        return $this->odometerField;
    }
    /**
     * Set odometerField value
     * @param float $odometerField
     * @return \StructType\GPSPointDetailType
     */
    public function setOdometerField($odometerField = null)
    {
        // validation for constraint: float
        if (!is_null($odometerField) && !(is_float($odometerField) || is_numeric($odometerField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($odometerField, true), gettype($odometerField)), __LINE__);
        }
        $this->odometerField = $odometerField;
        return $this;
    }
    /**
     * Get satellitesField value
     * @return int|null
     */
    public function getSatellitesField()
    {
        return $this->satellitesField;
    }
    /**
     * Set satellitesField value
     * @param int $satellitesField
     * @return \StructType\GPSPointDetailType
     */
    public function setSatellitesField($satellitesField = null)
    {
        // validation for constraint: int
        if (!is_null($satellitesField) && !(is_int($satellitesField) || ctype_digit($satellitesField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($satellitesField, true), gettype($satellitesField)), __LINE__);
        }
        $this->satellitesField = $satellitesField;
        return $this;
    }
    /**
     * Get speedField value
     * @return int|null
     */
    public function getSpeedField()
    {
        return $this->speedField;
    }
    /**
     * Set speedField value
     * @param int $speedField
     * @return \StructType\GPSPointDetailType
     */
    public function setSpeedField($speedField = null)
    {
        // validation for constraint: int
        if (!is_null($speedField) && !(is_int($speedField) || ctype_digit($speedField))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($speedField, true), gettype($speedField)), __LINE__);
        }
        $this->speedField = $speedField;
        return $this;
    }
}
