<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FormListForm StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:FormListForm
 * @subpackage Structs
 */
class FormListForm extends AbstractStructBase
{
    /**
     * The nameField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $nameField;
    /**
     * The valueField
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var \ArrayType\ArrayOfstring
     */
    public $valueField;
    /**
     * Constructor method for FormListForm
     * @uses FormListForm::setNameField()
     * @uses FormListForm::setValueField()
     * @param string $nameField
     * @param \ArrayType\ArrayOfstring $valueField
     */
    public function __construct($nameField = null, \ArrayType\ArrayOfstring $valueField = null)
    {
        $this
            ->setNameField($nameField)
            ->setValueField($valueField);
    }
    /**
     * Get nameField value
     * @return string|null
     */
    public function getNameField()
    {
        return $this->nameField;
    }
    /**
     * Set nameField value
     * @param string $nameField
     * @return \StructType\FormListForm
     */
    public function setNameField($nameField = null)
    {
        // validation for constraint: string
        if (!is_null($nameField) && !is_string($nameField)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameField, true), gettype($nameField)), __LINE__);
        }
        $this->nameField = $nameField;
        return $this;
    }
    /**
     * Get valueField value
     * @return \ArrayType\ArrayOfstring|null
     */
    public function getValueField()
    {
        return $this->valueField;
    }
    /**
     * Set valueField value
     * @param \ArrayType\ArrayOfstring $valueField
     * @return \StructType\FormListForm
     */
    public function setValueField(\ArrayType\ArrayOfstring $valueField = null)
    {
        $this->valueField = $valueField;
        return $this;
    }
}
