<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EventRecords StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:EventRecords
 * @subpackage Structs
 */
class EventRecords extends AbstractStructBase
{
    /**
     * The _atPos
     * @var int
     */
    public $_atPos;
    /**
     * The _duration
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $_duration;
    /**
     * The _eventType
     * @var string
     */
    public $_eventType;
    /**
     * The _intoShift
     * @var int
     */
    public $_intoShift;
    /**
     * The _startTm
     * @var string
     */
    public $_startTm;
    /**
     * Constructor method for EventRecords
     * @uses EventRecords::set_atPos()
     * @uses EventRecords::set_duration()
     * @uses EventRecords::set_eventType()
     * @uses EventRecords::set_intoShift()
     * @uses EventRecords::set_startTm()
     * @param int $_atPos
     * @param string $_duration
     * @param string $_eventType
     * @param int $_intoShift
     * @param string $_startTm
     */
    public function __construct($_atPos = null, $_duration = null, $_eventType = null, $_intoShift = null, $_startTm = null)
    {
        $this
            ->set_atPos($_atPos)
            ->set_duration($_duration)
            ->set_eventType($_eventType)
            ->set_intoShift($_intoShift)
            ->set_startTm($_startTm);
    }
    /**
     * Get _atPos value
     * @return int|null
     */
    public function get_atPos()
    {
        return $this->_atPos;
    }
    /**
     * Set _atPos value
     * @param int $_atPos
     * @return \StructType\EventRecords
     */
    public function set_atPos($_atPos = null)
    {
        // validation for constraint: int
        if (!is_null($_atPos) && !(is_int($_atPos) || ctype_digit($_atPos))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($_atPos, true), gettype($_atPos)), __LINE__);
        }
        $this->_atPos = $_atPos;
        return $this;
    }
    /**
     * Get _duration value
     * @return string|null
     */
    public function get_duration()
    {
        return $this->_duration;
    }
    /**
     * Set _duration value
     * @param string $_duration
     * @return \StructType\EventRecords
     */
    public function set_duration($_duration = null)
    {
        // validation for constraint: string
        if (!is_null($_duration) && !is_string($_duration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_duration, true), gettype($_duration)), __LINE__);
        }
        $this->_duration = $_duration;
        return $this;
    }
    /**
     * Get _eventType value
     * @return string|null
     */
    public function get_eventType()
    {
        return $this->_eventType;
    }
    /**
     * Set _eventType value
     * @uses \EnumType\TripEvent::valueIsValid()
     * @uses \EnumType\TripEvent::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $_eventType
     * @return \StructType\EventRecords
     */
    public function set_eventType($_eventType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TripEvent::valueIsValid($_eventType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TripEvent', is_array($_eventType) ? implode(', ', $_eventType) : var_export($_eventType, true), implode(', ', \EnumType\TripEvent::getValidValues())), __LINE__);
        }
        $this->_eventType = $_eventType;
        return $this;
    }
    /**
     * Get _intoShift value
     * @return int|null
     */
    public function get_intoShift()
    {
        return $this->_intoShift;
    }
    /**
     * Set _intoShift value
     * @param int $_intoShift
     * @return \StructType\EventRecords
     */
    public function set_intoShift($_intoShift = null)
    {
        // validation for constraint: int
        if (!is_null($_intoShift) && !(is_int($_intoShift) || ctype_digit($_intoShift))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($_intoShift, true), gettype($_intoShift)), __LINE__);
        }
        $this->_intoShift = $_intoShift;
        return $this;
    }
    /**
     * Get _startTm value
     * @return string|null
     */
    public function get_startTm()
    {
        return $this->_startTm;
    }
    /**
     * Set _startTm value
     * @param string $_startTm
     * @return \StructType\EventRecords
     */
    public function set_startTm($_startTm = null)
    {
        // validation for constraint: string
        if (!is_null($_startTm) && !is_string($_startTm)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($_startTm, true), gettype($_startTm)), __LINE__);
        }
        $this->_startTm = $_startTm;
        return $this;
    }
}
